% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initial_guesses.R
\name{make_guess_primary}
\alias{make_guess_primary}
\title{Initial guesses for fitting primary growth models}
\usage{
make_guess_primary(
  fit_data,
  primary_model,
  logbase_mu = 10,
  formula = logN ~ time
)
}
\arguments{
\item{fit_data}{the experimental data. A tibble (or data.frame) with a column
named \code{time} with the elapsed time and one called \code{logN} with the logarithm
of the population size}

\item{primary_model}{a string defining the equation of the primary model,
as defined in \code{\link[=primary_model_data]{primary_model_data()}}}

\item{logbase_mu}{Base of the logarithm the growth rate is referred to.
By default, 10 (i.e. log10). See vignette about units for details.}

\item{formula}{an object of class "formula" describing the x and y variables.
\code{logN ~ time} as a default.}
}
\value{
A named numeric vector of initial guesses for the model parameters
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

The function uses some heuristics to provide initial guesses for the parameters
of the growth model selected that can be used with \code{\link[=fit_growth]{fit_growth()}}.
}
\examples{

## An example of experimental data

my_data <- data.frame(time = 0:9, 
                      logN = c(2, 2.1, 1.8, 2.5, 3.1, 3.4, 4, 4.5, 4.8, 4.7))
                      
## We just need to pass the data and the model equation

make_guess_primary(my_data, "Logistic")

## We can use this together with fit_growth()

fit_growth(my_data,
           list(primary = "Logistic"),
           make_guess_primary(my_data, "Logistic"),
           c()
           )

## The parameters returned by the function are adapted to the model

make_guess_primary(my_data, "Baranyi")

## It can express mu in other logbases 

make_guess_primary(my_data, "Baranyi", logbase_mu = exp(1))  # natural
make_guess_primary(my_data, "Baranyi", logbase_mu = 2)  # base2

}
