% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/absorptionWater.R
\name{absorptionWater}
\alias{absorptionWater}
\title{absorptionWater}
\usage{
absorptionWater(f, pH = 8, t = 0, s = 35, z)
}
\arguments{
\item{f}{The frequency of the sound source in kHz.}

\item{pH}{The average acidity or pH of the water. Default is 8.}

\item{t}{The average temperature of the water in Celsius. Default is 0.}

\item{s}{The average salinity of the water in parts per thousand (ppt). Default is 35 ppt.}

\item{z}{The depth in km.}
}
\value{
The sound attenuation rate in dB/km
}
\description{
This function is a simplified method of calculating the absorption of sound
in water proposed in Ainslie and McColm, 1998 and based on Francois and Garrison, 1982.
}
\examples{
#How much are blue whale calls (30 kHz) absorbed in a tropical region
#(30 deg C) assuming a salinity of 35 ppt, pH of 8, and a depth of 5 km?
absorptionWater(30, 8, 30, 35, 5)
}
