% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binsreg-package.R
\docType{package}
\name{binsreg-package}
\alias{binsreg-package}
\title{Binsreg Package Document}
\description{
Binscatter provides a flexible, yet parsimonious way of visualizing and summarizing large data sets
             and has been a popular methodology in applied microeconomics and other social sciences. The binsreg package provides tools for
             statistical analysis using the binscatter methods developed in
             \href{https://nppackages.github.io/references/Cattaneo-Crump-Farrell-Feng_2024_AER.pdf}{Cattaneo, Crump, Farrell and Feng (2024a)} and
             \href{https://nppackages.github.io/references/Cattaneo-Crump-Farrell-Feng_2024_NonlinearBinscatter.pdf}{Cattaneo, Crump, Farrell and Feng (2024b)}.
             \code{\link{binsreg}} implements binscatter least squares regression with robust inference and plots, including
             curve estimation, pointwise confidence intervals and uniform confidence band.
             \code{\link{binsqreg}} implements binscatter quantile regression with robust inference and plots, including
             curve estimation, pointwise confidence intervals and uniform confidence band.
             \code{\link{binsglm}} implements binscatter generalized linear regression with robust inference and plots, including
             curve estimation, pointwise confidence intervals and uniform confidence band.
             \code{\link{binstest}} implements binscatter-based hypothesis testing procedures for parametric specifications
             of and shape restrictions on the unknown function of interest.
             \code{\link{binspwc}} implements hypothesis testing procedures for pairwise group comparison of binscatter estimators and plots confidence
             bands for the difference in binscatter parameters between each pair of groups.
             \code{\link{binsregselect}} implements data-driven number of bins selectors for binscatter
             implementation using either quantile-spaced or evenly-spaced binning/partitioning.
             All the commands allow for covariate adjustment, smoothness restrictions, and clustering,
             among other features.

             The companion software article,
             \href{https://nppackages.github.io/references/Cattaneo-Crump-Farrell-Feng_2024_Stata.pdf}{Cattaneo, Crump, Farrell and Feng (2024c)},
             provides further implementation details and empirical illustration. For related Stata, R and Python packages
             useful for nonparametric data analysis and statistical inference, visit
             \href{https://nppackages.github.io/}{https://nppackages.github.io/}.
}
\references{
Cattaneo, M. D., R. K. Crump, M. H. Farrell, and Y. Feng. 2024a: \href{https://nppackages.github.io/references/Cattaneo-Crump-Farrell-Feng_2024_AER.pdf}{On Binscatter}. American Economic Review 114(5): 1488-1514.

Cattaneo, M. D., R. K. Crump, M. H. Farrell, and Y. Feng. 2024b: \href{https://nppackages.github.io/references/Cattaneo-Crump-Farrell-Feng_2024_NonlinearBinscatter.pdf}{Nonlinear Binscatter Methods}. Working Paper.

Cattaneo, M. D., R. K. Crump, M. H. Farrell, and Y. Feng. 2024c: \href{https://nppackages.github.io/references/Cattaneo-Crump-Farrell-Feng_2024_Stata.pdf}{Binscatter Regressions}. Working Paper.
}
\author{
Matias D. Cattaneo, Princeton University, Princeton, NJ. \email{cattaneo@princeton.edu}.

Richard K. Crump, Federal Reserve Bank of New York, New York, NY. \email{richard.crump@ny.frb.org}.

Max H. Farrell, UC Santa Barbara, Santa Barbara, CA. \email{mhfarrell@gmail.com}.

Yingjie Feng (maintainer), Tsinghua University, Beijing, China. \email{fengyingjiepku@gmail.com}.
}
