% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binovfcal.R
\name{binovfcal}
\alias{binovfcal}
\title{Calculates an array of integrated visual fields}
\usage{
binovfcal(leftvf, rghtvf, lefttheta, righttheta, distplanes, pd = NULL,
  gender = NULL, m_xs = seq(-27, 27, length.out = 10), m_ys = seq(21,
  -21, -6), c_xs = seq(-57, 57, 6), db_cutoff = 25)
}
\arguments{
\item{leftvf}{A matrix of left monocular visual field}

\item{rghtvf}{A matrix of right monocular visual field}

\item{lefttheta}{A number angle of convergence for the left eye in radian}

\item{righttheta}{A number  angle of convergence for the right eye in radian}

\item{distplanes}{A vector of object distances in mm.}

\item{pd}{Pupil distance in mm}

\item{gender}{A string of either "male" or "female"}

\item{m_xs}{Horizontal coordinates for monocular visual field for the 24-2 pattern}

\item{m_ys}{Vertical coordinates for monocular visual field for the 24-2 pattern}

\item{c_xs}{Horizontal coordinates for integrated visual field (from -57 to 57 degree with 6 degree spacing)}

\item{db_cutoff}{cutoff value default to 25 dB above which the simulated threshold value is returned (NA otherwise) when there threshold value is present only for one eye}
}
\value{
An array of binocular visual fields for the distances specified by distplanes vector.
}
\description{
\code{binovfcal} calculates an array of integrated visual fields given required parameters.
}
\section{Warning}{

the value of either pd or gender has to be provided
the unit of pd and fixdist must be the same, default to mm.
}

\examples{
rghtvf <- matrix(c(
NA, NA, NA, 30, 30, 30, 30, NA, NA, NA,
NA, NA, 30, 30, 30, 30, 30, 30, NA, NA,
NA, 30, 30, 30, 30, 30, 30, 30, 30, NA,
30, 30, 30, 30, 30, 30, 30, 30, 30, NA,
30, 30, 30, 30, 30, 30, 30,  0, 30, NA,
NA, 30, 30, 30, 30, 30, 30, 30, 30, NA,
NA, NA, 30, 30, 30, 30, 30, 30, NA, NA,
NA, NA, NA, 30, 30, 30, 30, NA, NA, NA
), ncol=10, byrow=TRUE)
leftvf <- rghtvf[, 10:1]
binovfcal(leftvf, rghtvf, -.045, .045, c(1000, 1010), pd=62)
}
