% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigtcr_func.R
\name{get.gap.kt}
\alias{get.gap.kt}
\title{Cause-Specific Kendall's tau Estimation}
\usage{
get.gap.kt(obs.y, event, v, tau = Inf, nbs = 0)
}
\arguments{
\item{obs.y}{\eqn{Y}: time to failure events or censoring}

\item{event}{0: censored; \eqn{1, \ldots J}: type of failure events}

\item{v}{Time to the first failure event (e.g. disease recurrence)}

\item{tau}{Conditioning time \eqn{\tau} under which the CCIF is defined}

\item{nbs}{Number of bootstrap samples for bootstrap variances. When nbs is
smaller than 1, bootstrap variances are not evaluated.}
}
\value{
A list of the estimation and variances of modified casue-specific Kendall's
tau
}
\description{
Estimate the modified cause-specific Kendall's tau for the evaluation of
association for bivariate gap time with competing risks. See \code{\link{bigtcr-package}}.
}
\examples{

Kt <- get.gap.kt(obs.y=pancancer$obs.y, event=pancancer$min.type,
               v=pancancer$v, tau=120, nbs=5)

}

