% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df2bib.R
\name{df2bib}
\alias{df2bib}
\title{Export a BibTeX \code{tibble} to a .bib file}
\usage{
df2bib(x, file = "", append = FALSE, allfields = TRUE)
}
\arguments{
\item{x}{\code{tibble}, in the format as returned by \code{\link{bib2df}}.}

\item{file}{character, file path to write the .bib file. An empty character string writes to \code{stdout} (default).}

\item{append}{logical, if \code{TRUE} the \code{tibble} will be appended to an existing file.}

\item{allfields}{logical, if \code{TRUE} (default), the resulting bib output
will include all the BibTeX fields contained in the df object. If \code{FALSE}
only the fields with text will be included in the resulting bib object}
}
\value{
\code{file} as a character string, invisibly.
}
\description{
The BibTeX \code{tibble} is written to a .bib file
}
\examples{
# Read from .bib file:
path <- system.file("extdata", "bib2df_testfile_3.bib", package = "bib2df")
bib <- bib2df(path)

# Write to .bib file:
# bibFile <- tempfile()
# df2bib(bib, bibFile)

# Use `append = TRUE` to add lines to an existing .bib file:
# df2bib(bib, bibFile, append = TRUE)
}
\references{
\url{https://www.bibtex.org/Format/}
}
\seealso{
\code{\link{bib2df}}
}
\author{
Thomas J. Leeper

Gianluca Baio
}
