% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfsl.R
\name{tidy.bfsl}
\alias{tidy.bfsl}
\title{Tidy a bfsl Object}
\usage{
\method{tidy}{bfsl}(x, conf.int = FALSE, conf.level = 0.95, ...)
}
\arguments{
\item{x}{A `bfsl` object.}

\item{conf.int}{Logical indicating whether or not to include
a confidence interval in the tidied output. Defaults to FALSE.}

\item{conf.level}{The confidence level to use for the confidence
interval if conf.int = TRUE. Must be strictly greater than 0
and less than 1. Defaults to 0.95, which corresponds to a
95 percent confidence interval.}

\item{...}{Unused, included for generic consistency only.}
}
\value{
A tidy [tibble::tibble()] summarizing component-level
  information about the model
}
\description{
Broom tidier method to \code{tidy} a bfsl object.
}
\examples{
fit = bfsl(pearson_york_data)

tidy(fit)

}
