% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{UABMSL}
\alias{UABMSL}
\title{Upper Location Parameter Given Shape Parameters, Mean, Variance, and Lower Location Parameter of a Four-Parameter Beta Probability Density Distribution.}
\usage{
UABMSL(
  alpha = NULL,
  beta = NULL,
  mean = NULL,
  variance = NULL,
  l = NULL,
  sd = NULL
)
}
\arguments{
\item{alpha}{The alpha shape-parameter of the target Beta probability density distribution.}

\item{beta}{The beta shape-parameter of the target Beta probability density distribution.}

\item{mean}{The mean (first raw moment) of the target Standard Beta probability density distribution.}

\item{variance}{The variance (second central moment) of the target Standard Beta probability density distribution.}

\item{l}{The lower-bound of the Beta distribution. Default is NULL (i.e., does not take a specified l-parameter into account).}

\item{sd}{Optional alternative to specifying \code{var}. The standard deviation of the target Standard Beta probability density distribution.}
}
\value{
A numeric value representing the required value for the Beta upper location-parameter (\code{u}) in order to produce a Beta probability density distribution with the target moments and parameters.
}
\description{
Calculates the upper-bound value required to produce a Beta probability density distribution with defined moments and parameters. Be advised that not all combinations of moments and parameters can be satisfied (e.g., specifying mean, variance, skewness and kurtosis uniquely determines both location-parameters, meaning that the value of the upper-location parameter will take on which ever value it must, and cannot be specified).
}
\examples{
# Generate some fictional data.
set.seed(1234)
testdata <- rBeta.4P(100000, 0.25, 0.75, 5, 3)
hist(testdata, xlim = c(0, 1), freq = FALSE)

# Suppose you know three of the four necessary parameters to fit a four-
# parameter Beta distribution (i. e., l = 0.25, alpha = 5, beta = 3) to this
# data. To find the value for the necessary u parameter, estimate the mean
# and variance of the distribution:
M <- mean(testdata)
S2 <- var(testdata)

# To find the l parameter necessary to produce a four-parameter Beta
# distribution with the target mean, variance, and u, alpha, and beta
# parameters using the LMSBAU() function:
(u <- UABMSL(alpha = 5, beta = 3, mean = M, variance = S2, l = 0.25))
curve(dBeta.4P(x, 0.25, u, 5, 3), add = TRUE, lwd = 2)
}
