% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{Beta.2p.fit}
\alias{Beta.2p.fit}
\title{Method of Moment Estimates of Shape-Parameters of the Two-Parameter (Standard) Beta Distribution.}
\usage{
Beta.2p.fit(scores = NULL, mean = NULL, variance = NULL, l = 0, u = 1)
}
\arguments{
\item{scores}{A vector of values to which the two-parameter Beta distribution is to be fitted. The values ought to fall within the [0, 1] interval.}

\item{mean}{The mean of the target Beta distribution. Alternative to feeding the function raw scores.}

\item{variance}{The variance of the target Beta distribution. Alternative to feeding the function raw scores.}

\item{l}{Optional specification of a lower-bound parameter of the Beta distribution. Default is 0 (i.e., the lower-bound of the Standard two-parameter Beta distribution).}

\item{u}{Optional specification of an upper-bound parameter of the Beta distribution. Default is 1 (i.e., the lower-bound of the Standard two-parameter Beta distribution).}
}
\value{
A list of parameter-values required to produce a Standard two-parameter Beta distribution with the same first two moments as the observed distribution.
}
\description{
An implementation of the method of moments estimation of two-parameter Beta distribution parameters. Given a vector of values, calculates the shape parameters required to produce a two-parameter Beta distribution with the same mean and variance (i.e., the first two moments) as the observed-score distribution.
}
\examples{
# Generate some fictional data. Say, 100 individuals take a test with a
# maximum score of 100 and a minimum score of 0.
set.seed(1234)
testdata <- rbinom(100, 100, rBeta.4P(100, 0.25, 0.75, 5, 3)) / 100
hist(testdata, xlim = c(0, 1), freq = FALSE)

# To fit and retrieve the parameters for a two-parameter Beta distribution
# to the observed-score distribution using Beta.2p.fit():
(params.2p <- Beta.2p.fit(testdata))
curve(dbeta(x, params.2p$alpha, params.2p$beta), add = TRUE)
}
