% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/double_reverse_log.R
\name{double_reverse_log}
\alias{double_reverse_log}
\alias{predict.double_reverse_log}
\alias{print.double_reverse_log}
\title{Double Reverse Log(x + a) Transformation}
\usage{
double_reverse_log(
  x,
  b = 10,
  standardize = TRUE,
  eps = diff(range(x, na.rm = TRUE))/10,
  warn = TRUE,
  ...
)

\method{predict}{double_reverse_log}(object, newdata = NULL, inverse = FALSE, ...)

\method{print}{double_reverse_log}(x, ...)
}
\arguments{
\item{x}{A vector to normalize with with x}

\item{b}{The base of the log (defaults to 10)}

\item{standardize}{If TRUE, the transformed values are also centered and
scaled, such that the transformation attempts a standard normal}

\item{eps}{The cushion for the transformation range (defaults to 10 percent)}

\item{warn}{Should a warning result from infinite values?}

\item{...}{additional arguments}

\item{object}{an object of class 'double_reverse_log'}

\item{newdata}{a vector of data to be (potentially reverse) transformed}

\item{inverse}{if TRUE, performs reverse transformation}
}
\value{
A list of class \code{double_reverse_log} with elements 
\item{x.t}{transformed 
  original data} 
  \item{x}{original data} 
  \item{mean}{mean after transformation but prior to standardization} 
  \item{sd}{sd after transformation but prior to standardization} 
  \item{b}{estimated base b value} 
  \item{n}{number of nonmissing observations}
  \item{norm_stat}{Pearson's P / degrees of freedom}
  \item{standardize}{was the transformation standardized}
  
  The \code{predict} function returns the numeric value of the transformation
  performed on new data, and allows for the inverse transformation as well.
}
\description{
First reverses scores, then perform a log_b(x) 
normalization transformation, and then reverses scores again.
}
\details{
\code{double_reverse_log} performs a simple log transformation in the 
context of bestNormalize, such that it creates a transformation that can be 
estimated and applied to new data via the \code{predict} function. The parameter 
a is essentially estimated by the training set by default (estimated as the 
minimum possible to some extent epsilon), while the base must be specified 
beforehand.
}
\examples{
x <- rgamma(100, 1, 1)

double_reverse_log_obj <- double_reverse_log(x)
double_reverse_log_obj
p <- predict(double_reverse_log_obj)
x2 <- predict(double_reverse_log_obj, newdata = p, inverse = TRUE)

all.equal(x2, x)

}
