% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/belex.r
\name{belex}
\alias{belex}
\title{Download Historical Data from the Belgrade Stock Exchange}
\usage{
belex(ticker, from = NULL, to = NULL)
}
\arguments{
\item{ticker}{a character string giving the name of the ticker or
index to download. See the web page of the data provider
http://belex.rs for information about the available ticker
symbols and indexes. See below.}

\item{from}{date of the start of the period to download.
This must be in the following format: yyyy-mm-dd.
Defaults to the first available data.}

\item{to}{date of the end of the period to download.
This must be in the following format: yyyy-mm-dd.
Defaults to the last available data.}
}
\value{
A list consists of five components: \code{ticker}, \code{from}, \code{to},
\code{nrows} and \code{data}.
Component \code{data} is a data frame with the following time series:
Date, Close, Transactions, Volume, Open, Low, High, Total Bid, Total Ask.
}
\description{
\code{belex} function downloads historical financial time series
from the Belgrade Stock Exchange. One can specify which ticker
or index to download, from and to date.
}
\details{
The name of the Belgrade Stock Exchange
index is BELEX15 (from September 2005).
}
\examples{
\dontrun{
Belex15 index from 2009-11-23 to 2012-05-15

belex15.data <- belex("belex15", "2009-11-23", "2012-05-15")

All available data for ticker AIKB

aikb.data <- belex("AIKB")

Data for ticker NIIS from 2010-10-01

niis.data <- belex("NIIS", from = "2010-10-01")

Data for ticker IMLK from beginning to 2010-05-12

imlk.data <- belex("IMLK", to = "2010-05-12")
}

}
\author{
Milos Vilotic and Zlatko Kovacic
}

