% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Middleware.R
\docType{class}
\name{Middleware}
\alias{Middleware}
\title{Middleware Class}
\format{
An [`R6::R6Class`] generator for `Middleware` objects.
}
\description{
A `Middleware` object wraps a handler function with associated metadata
(`path`, `method`, `protocol`). Middleware functions have access to the
request (`req`), response (`res`), and error (`err`) objects during the
request–response cycle via the [`Router`].
}
\seealso{
[Router], [Request], [Response], [Error]
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{path}}{Path this middleware matches, or `NULL` for all paths.}

\item{\code{FUN}}{Handler function executed when matched.}

\item{\code{method}}{HTTP method to match (e.g., `"GET"`), or `NULL` for any.}

\item{\code{protocol}}{Protocol string: `"http"` or `"websocket"`.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Middleware-new}{\code{Middleware$new()}}
\item \href{#method-Middleware-clone}{\code{Middleware$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Middleware-new"></a>}}
\if{latex}{\out{\hypertarget{method-Middleware-new}{}}}
\subsection{Method \code{new()}}{
Initialize middleware with handler, path, method, and protocol selection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Middleware$new(FUN, path, method, websocket)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{FUN}}{Handler function (e.g., `(req, res, err)` for HTTP).}

\item{\code{path}}{Route path to match, or `NULL` for all.}

\item{\code{method}}{HTTP method to match, or `NULL` for any.}

\item{\code{websocket}}{If `TRUE`, set `protocol = "websocket"`; otherwise `"http"`.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Middleware-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Middleware-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Middleware$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
