% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdsvd.R
\name{bdsvd.cov.sim}
\alias{bdsvd.cov.sim}
\title{Covariance Matrix Simulation for BD-SVD}
\usage{
bdsvd.cov.sim(p = p, b, design = design)
}
\arguments{
\item{p}{Number of variables.}

\item{b}{Number of blocks. Only required for simulation design "c" and "d".}

\item{design}{Simulation design "a", "b", "c", or "d".}
}
\value{
A covariance matrix according to the chosen simulation design.
}
\description{
This function generates covariance matrices based on the simulation studies described in Bauer (2024).
}
\examples{
#The covariance matrix for simulation design (a) is given by
Sigma <- bdsvd.cov.sim(p = 500, b = 500, design = "a")

}
\references{
\cite{Bauer, J.O. (2024). High-dimensional block diagonal covariance structure detection using singular vectors, J. Comput. Graph. Stat.}
}
