% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_unit_localities.R
\name{search_unit_localities}
\alias{search_unit_localities}
\title{Search for unit localities}
\usage{
search_unit_localities(
  name,
  year = NULL,
  sort = c("id", "-id", "name", "-name"),
  lang = c("pl", "en"),
  ...
)
}
\arguments{
\item{name}{A phrase to search.}

\item{year}{A vector of years. If \code{NULL} (default) returns data for all available years.}

\item{sort}{A type of sorting, "id" (default), "-id", "name", "-name"}

\item{lang}{A language of returned data, "pl" (default), "en"}

\item{...}{Other arguments passed on to \code{\link[httr]{GET}}. For example
a proxy parameters, see details.}
}
\value{
A dataset as a tibble.
}
\description{
Search for a given phrase in unit locality names.
}
\details{
To use a proxy to connect, a \code{\link[httr]{use_proxy}} can be
  passed to \code{\link[httr]{GET}}. For example
  \code{get_request(id, filters,
  config = httr::use_proxy(url, port, username, password))}.
}
\examples{
   # search_unit_localities("wro")
}
\keyword{localities}
\keyword{search}
\keyword{units}
\keyword{utilities}
