% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcreg.R
\name{bcreg}
\alias{bcreg}
\title{Linear regression model with the Box-Cox Transformation.}
\usage{
bcreg(formula, data, lmdint = c(-3, 3))
}
\arguments{
\item{formula}{a two-sided linear formula object describing the model, with
the response on the left of a ~ operator and the terms, separated by +
operators, on the right.}

\item{data}{a data frame in which to interpret the variables named in the
formula.}

\item{lmdint}{a vector containing the end-points of the interval to be
searched for a transformation parameter. Default is c(-3, 3).}
}
\value{
bcreg returns a list including following components:
\describe{
  \item{\code{lambda}}{a numeric value with the estimate of
        the transformation parameter.}
  \item{\code{beta}}{a vector with the estimates of the regression
        parameters.}
  \item{\code{sigma}}{a numeric value with the estimate of the scale
        parameter.}
  \item{\code{betainf}}{a data frame with inference results for \code{beta}
        under the assumption that \code{lambda} is known.}
  \item{\code{lik}}{a numeric value with the maximized likelihood.}
  \item{\code{lmObject}}{an object of "\code{lm}" containing the results of
        \code{lm} function on the transformed scale}
}
}
\description{
\code{bcreg} returns the maximum likelihood estimates for parameters of
the linear regression models with the Box-Cox transformation (Box and Cox,
1964).
}
\examples{
  data(aidscd4)
  #Transformation of baseline observation for aid.cd4 data
  bcreg(cd4.bl ~ 1, aidscd4[aidscd4$weekc == 8, ])

}
\references{
Box, G.E.P. and Cox, D.R. (1964). An analysis of transformations
(with discussion).
\emph{Journals of the Royal Statistical Society, Series B}, 26,
211-246, \doi{10.1111/j.2517-6161.1964.tb00553.x}.
}
\seealso{
\code{\link{lm}}
}
