% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbn.visualise.R
\name{bbn.visualise}
\alias{bbn.visualise}
\title{Visualise Bayesian Belief Network Time Series Predictions}
\usage{
bbn.visualise(
  bbn.model,
  priors1,
  timesteps = 5,
  disturbance = 1,
  threshold = 0.2,
  font.size = 0.7,
  arrow.size = 4
)
}
\arguments{
\item{bbn.model}{A matrix or dataframe of interactions between different model \code{nodes}.}

\item{priors1}{An X by 2 array of initial changes to the system under investigation.
The first column should be a -4 to 4 (including 0) integer value for each \code{node} in the network with negative values
indicating a decrease and positive values representing an increase. 0 represents no change.}

\item{timesteps}{This is the number of \code{timesteps} the model performs. Default = 5.
Note, \code{timesteps} are arbitrary and non-linear. However, something occurring in \code{timestep 2}, should occur before \code{timestep 3}.}

\item{disturbance}{Default = 1.
1 creates a prolonged or press \code{disturbance} as per \code{\link{bbn.predict}}
Essentially \code{prior} values for each manipulated \code{node} are at least maintained (if not increased through reinforcement in the model) over all \code{timesteps}.
2 shows a brief pulse \code{disturbance}, which can be useful to visualise changes as peaks and troughs in increase and decrease of \code{nodes} can propagate through the network.}

\item{threshold}{\code{Nodes} which deviate from 0 by more than this \code{threshold} value will display interactions with other \code{nodes}.
Default = 0.2.
Values in these visualisation functions don’t directly correspond to those in \code{\link{bbn.predict}}.
This value can be tweaked from 0 to 4 to create the most useful visualisations.}

\item{font.size}{Changes the font in the figure produced. Default = 0.7.
The value here is a multiplier of the default font size used in the \code{igraph} package and does not correspond to the \code{font.size} argument in the \code{\link{bbn.timeseries}}.}

\item{arrow.size}{Changes the size of the arrows. Default = 4.
Note, sizes do vary based on interaction strength, so this is a multiplier for visualisation purposes.}
}
\value{
A plot of the \code{BBN}, illustrating the dynamic interactions between \code{nodes} over the specified \code{timesteps}.
}
\description{
\code{bbn.visualise()} visualises the outcomes of a Bayesian Belief Network (\code{BBN}) model over time,
given a single \code{prior} scenario. It highlights the changes in network parameters across specified \code{timesteps}
and visualises the strength and direction of interactions among \code{nodes} based on the specified \code{disturbance}
and \code{threshold} parameters.
}
\examples{
data(my_BBN, combined)
bbn.visualise(bbn.model = my_BBN, priors1 = combined,
  timesteps=6, disturbance=1, threshold=0.2, font.size=0.7, arrow.size=4)

}
