% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbmix.R
\name{fit_bb}
\alias{fit_bb}
\title{Fit beta binomial distribution to allelic counts for homozygous reference, heterozygous, homozygous alternative}
\usage{
fit_bb(
  counts_f,
  depth = 10,
  N = 1000,
  prefix = NULL,
  k = 3,
  alpha_p = c(1, 10, 499),
  beta_p = c(499, 10, 1),
  out,
  mc.cores = NULL
)
}
\arguments{
\item{counts_f}{file name with allele counts for SNPs}

\item{depth}{depth cut-off to use to select SNPs to fit  distributions}

\item{N}{number of SNPs to use for fitting}

\item{prefix}{charcter with prefix to add for saving files, defaults to NULL}

\item{k}{number of components for mixture model, defaults to 3}

\item{alpha_p}{alpha parameter for the k components of alpha parameter}

\item{beta_p}{beta paramenter for the k components of Beta parameter}

\item{out}{character with dir name to save output}

\item{mc.cores}{number of cores to use, defaults to parallel detected cores}
}
\value{
saves stan object to file
}
\description{
Fit beta binomial distribution to allelic counts for homozygous reference, heterozygous, homozygous alternative
}
\examples{

\dontrun{
## Retrive input files for running call_gt
counts_f <- system.file("extdata/input", "NA12878.chr22.Q20.allelicCounts.txt",
package = "bbmix",
mustWork = TRUE)

out <- tempdir()
fit_bb(counts_f = counts_f, N=10,
out = out, mc.cores=1)
unlink(out)
}

}
