% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{run_dating_alg}
\alias{run_dating_alg}
\title{Runs the dating algorithm to identify Bull and Bear states}
\usage{
run_dating_alg(index)
}
\arguments{
\item{index}{vector containing the stock price index}
}
\value{
A logical vector that contains TRUE for Bull states and FALSE for Bear states
}
\description{
This function implements the dating algorithm of Bry and Boschan (1971) to identify Bull and Bear states
}
\note{
Be aware that the states in the beginning and in the end of \code{"index"} are not properly defined.
The users are advised to always visually check the correctness of the result
(during Bull states the prices should generally increase, during the Bear states decrease).
}
\references{
Bry, G. and Boschan, C. (1971). Cyclical Analysis of Time Series: Selected Procedures and
Computer Programs. NBER.

Pagan, A. R. and Sossounov, K. A. (2003). A Simple Framework for Analysing Bull and Bear
Markets. Journal of Applied Econometrics, 18 (1), 23-46.

Gonzalez, L., Powell, J. G., Shi, J., and Wilson, A. (2005). Two Centuries of Bull and Bear
Market Cycles. International Review of Economics and Finance, 14 (4), 469-486.
}
