% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.bayesianVARs_fitted}
\alias{plot.bayesianVARs_fitted}
\title{Visualization of in-sample fit of an estimated VAR.}
\usage{
\method{plot}{bayesianVARs_fitted}(
  x,
  dates = NULL,
  vars = "all",
  quantiles = c(0.05, 0.5, 0.95),
  n_col = 1L,
  ...
)
}
\arguments{
\item{x}{A \code{bayesianVARs_fitted} object.}

\item{dates}{optional vector of dates for labelling the x-axis. The default
values is \code{NULL}; in this case, the axis will be labeled with numbers.}

\item{vars}{character vector containing the names of the variables to be
visualized. The default is \code{"all"} indicating that the fit of all variables
is visualized.}

\item{quantiles}{numeric vector indicating which quantiles to plot.}

\item{n_col}{integer indicating the number of columns to use for plotting.}

\item{...}{Currently ignored.}
}
\value{
returns \code{x} invisibly
}
\description{
Visualization of in-sample fit of an estimated VAR.
}
\examples{
# Access a subset of the usmacro_growth dataset
data <- usmacro_growth[,c("GDPC1", "CPIAUCSL", "FEDFUNDS")]

# Estimate a model
mod <- bvar(data, sv_keep = "all", quiet = TRUE)

# Simulate predicted historical values including the error term.
pred <- fitted(mod, error_term = TRUE)

# Visualize
plot(pred)
}
\seealso{
\itemize{
\item fitted method for class 'bayesianVARs_bvar': \code{\link[=fitted.bayesianVARs_bvar]{fitted.bayesianVARs_bvar()}}.
\item Other plotting \code{\link[=plot.bayesianVARs_bvar]{plot.bayesianVARs_bvar()}},
\code{\link[=plot.bayesianVARs_fitted]{plot.bayesianVARs_fitted()}}, \code{\link[=plot.bayesianVARs_predict]{plot.bayesianVARs_predict()}},
\code{\link[=pairs.bayesianVARs_predict]{pairs.bayesianVARs_predict()}}, \code{\link[=posterior_heatmap]{posterior_heatmap()}}.
}
}
