% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MDSIC.R
\name{MDSIC}
\alias{MDSIC}
\title{compute and plot MDSIC}
\usage{
MDSIC(x, plot = TRUE, ...)
}
\arguments{
\item{x}{an object of class \code{bmds}, the output of the function \code{bmds}}

\item{plot}{TRUE/FALSE,  if TRUE plot the number of dimensions versus  MDSIC  (default=TRUE)}

\item{...}{arguments to be passed to methods}
}
\value{
a list of \code{MDSIC} results
\describe{
  \item{mdsic}{MDSIC, for p =1,..,max_p}
  \item{llike}{log likelihood term in MDSIC, for p=1,...,max_p}
  \item{penalty}{ penalty term in MDSIC, for p=1,...,max_p}
}
}
\description{
compute and plot  MDSIC, a Bayesian selection criterion,
 given in Oh and Raftery (2001) 
based on the output of the function \code{bmds}
}
\details{
\emph{Notes}
To compute MDSIC, output of the function \code{bmds} for 
\code{min_p}=1 is needed for sequential calculation of MDSIC.
}
\examples{
\donttest{
data(cityDIST)
out <- bmds(cityDIST, min_p=1, max_p=5 )
MDSIC(out)
}
}
\references{
Oh, M-S., Raftery A.E. (2001). Bayesian Multidimensional Scaling and Choice of Dimension, 
 Journal of the American Statistical Association, 96, 1031-1044.
}
