% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osterbds.R
\name{osterbds}
\alias{osterbds}
\title{Computes identified set according to Oster (2019)}
\usage{
osterbds(parameters, Rmax)
}
\arguments{
\item{parameters}{A vector of parameters that is generated after estimating the short, intermediate and auxiliary regressions.}

\item{Rmax}{A real number which lies between Rtilde (R-squared for the intermediate regression) and 1.}
}
\value{
A data frame with three columns:
\item{Discriminant}{The value of the discriminant of the quadratic equation that is solved to generate the identified set}
\item{Interval1}{The interval formed with the first root of the quadratic equation}
\item{Interval2}{The interval formed with the first root of the quadratic equation}
}
\description{
Computes identified set according to Oster (2019)
}
\examples{
## Load data set
data("NLSY_IQ")
 
## Set age and race as factor variables
NLSY_IQ$age <- factor(NLSY_IQ$age)
NLSY_IQ$race <- factor(NLSY_IQ$race)
   
## Collect parameters from the short, intermediate and auxiliary regressions
parameters <- collect_par(
data = NLSY_IQ, outcome = "iq_std", 
treatment = "BF_months", 
control = c("age","sex","income","motherAge","motherEDU","mom_married","race"),
other_regressors = c("sex","age"))

## Oster's method: bounding sets when Rmax=0.61
osterbds(parameters = parameters, Rmax=0.61)

}
