% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchmeans.R
\name{estvssamp}
\alias{estvssamp}
\title{Create a plot that shows how Monte Carlo estimates change with increasing sample size.}
\usage{
estvssamp(x, fun = mean, main = "Estimate vs Sample Size", add = FALSE,
  ...)
}
\arguments{
\item{x}{a sample vector.}

\item{fun}{a function such that \eqn{E(fun(x))} is the quantity of interest. The default is \code{fun = \link{mean}}.}

\item{main}{an overall title for the plot. The default is \dQuote{\code{Estimates vs Sample Size}}.}

\item{add}{logical. If \code{TRUE}, add to a current plot.}

\item{\dots}{additional arguments to the plotting function.}
}
\value{
\code{NULL}
}
\description{
Create a plot that shows how Monte Carlo estimates change with increasing sample size.
}
\examples{

# Simulate a sample path of length 10,000 for an AR(1) chain with rho equal to 0.7.

X = numeric(10000)
X[1] = 1
for (i in 1:9999)
    X[i + 1] = 0.7 * X[i] + rnorm(1)

# Plot MC estimates versus sample size.

estvssamp(X)
}

