% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights.R
\name{weights_pool}
\alias{weights_pool}
\alias{weights_pool,OneStageBasket-method}
\alias{weights_pool,TwoStageBasket-method}
\title{Pooled Analysis}
\usage{
weights_pool(design, ...)

\S4method{weights_pool}{OneStageBasket}(design, n, ...)

\S4method{weights_pool}{OneStageBasket}(design, n, ...)

\S4method{weights_pool}{TwoStageBasket}(design, n, n1, ...)
}
\arguments{
\item{design}{An object of class \code{Basket} created by
\code{setupOneStageBasket} or \code{setupTwoStageBasket}.}

\item{...}{Further arguments.}

\item{n}{The sample size per basket.}

\item{n1}{The sample size per basket for the interim analysis in case of a
two-stage design.}
}
\value{
A weight matrix where all weights are 1.
}
\description{
Pooled Analysis
}
\details{
When \code{weights_pool} is used as a weight function, all data
are pooled.
}
\section{Methods (by class)}{
\itemize{
\item \code{weights_pool(OneStageBasket)}: Pooled analysis for a single-stage basket design

\item \code{weights_pool(OneStageBasket)}: Pooled analysis for a single-stage basket design

\item \code{weights_pool(TwoStageBasket)}: Pooled analysis for a two-stage basket design

}}
\examples{
design <- setupOneStageBasket(k = 3, p0 = 0.2)
toer(design, n = 15, lambda = 0.99, weight_fun = weights_pool)
}
