% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opt_design.R
\name{opt_design}
\alias{opt_design}
\alias{opt_design,OneStageBasket-method}
\alias{opt_design,TwoStageBasket-method}
\title{Optimize a Basket Design}
\usage{
opt_design(design, ...)

\S4method{opt_design}{OneStageBasket}(
  design,
  n,
  alpha,
  weight_fun,
  weight_params = list(),
  globalweight_fun = NULL,
  globalweight_params = list(),
  scenarios,
  prec_digits,
  ...
)

\S4method{opt_design}{TwoStageBasket}(
  design,
  n,
  n1,
  alpha,
  interim_fun,
  interim_params = list(),
  weight_fun,
  weight_params = list(),
  globalweight_fun = NULL,
  globalweight_params = list(),
  scenarios,
  prec_digits,
  ...
)
}
\arguments{
\item{design}{An object of class \code{Basket} created by
\code{setupOneStageBasket} or \code{setupTwoStageBasket}.}

\item{...}{Further arguments.}

\item{n}{The sample size per basket.}

\item{alpha}{The one-sided signifance level.}

\item{weight_fun}{Which function should be used to calculate the pairwise
weights.}

\item{weight_params}{A list of tuning parameters specific to
\code{weight_fun}.}

\item{globalweight_fun}{Which function should be used to calculate the
global weights.}

\item{globalweight_params}{A list of tuning parameters specific to
\code{globalweight_fun}.}

\item{scenarios}{A matrix of response rate scenarios. Each column corresponds
to a scenario and each row corresponds to a basket. A default scenario
matrix can be created with \code{\link{get_scenarios}}.}

\item{prec_digits}{Number of decimal places that are considered when
adjusting lambda.}

\item{n1}{The sample size per basket for the interim analysis in case of a
two-stage design.}

\item{interim_fun}{Which type of interim analysis should be conducted
in case of a two-stage design.}

\item{interim_params}{A list of tuning parameters specific to
\code{interim_fun}.}
}
\value{
A matrix with the ECDs under all scenarios and the mean ECD for
all combinations of tuning parameter values. The matrix is sorted
decreasingly by the mean ECD.
}
\description{
Finds the optimal tuning parameters using grid search.
}
\details{
\code{opt_design} finds the optimal combination of tuning parameter
values from a the set of tuning paramters that is passed to the function.
The objective function for the optimization is the mean of the expected
number of correct decisions (ECD) under the passed scenarios, with the
constraint that the type 1 error under the global null hypothesis must be
below \code{alpha}.
}
\section{Methods (by class)}{
\itemize{
\item \code{opt_design(OneStageBasket)}: Optimize a single-stage basket design.

\item \code{opt_design(TwoStageBasket)}: Optimize a two-stage basket design.

}}
\examples{
\donttest{
design <- setupOneStageBasket(k = 3, p0 = 0.2)
opt_design(design = design, n = 10, alpha = 0.05,
  weight_fun = weights_fujikawa, weight_params = list(epsilon = c(1, 2),
  tau = c(0, 0.5)), scenarios = get_scenarios(design, 0.5), prec_digits = 3)
}
}
