% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basket.r
\name{basket}
\alias{basket}
\title{Create a Basket Trial Analysis}
\usage{
basket(
  responses,
  size,
  name,
  p0 = 0.15,
  shape1 = 0.5,
  shape2 = 0.5,
  prior = diag(length(responses))/2 + matrix(0.5, nrow = length(responses), ncol =
    length(responses)),
  hpd_alpha = 0.05,
  alternative = "greater",
  call = NULL,
  cluster_function = cluster_membership,
  method = c("mcmc", "lmem", "exact"),
  mcmc_iter = 2e+05,
  mcmc_burnin = 50000,
  initial_mem = round(prior - 0.001),
  cluster_analysis = FALSE,
  seed = get_seed()
)
}
\arguments{
\item{responses}{the number of responses in each basket.}

\item{size}{the size of each basket.}

\item{name}{the name of each basket.}

\item{p0}{the null response rate for the poster probability calculation.
(default 0.15)}

\item{shape1}{the first shape parameter(s) for the prior of each basket.
(default 0.5)}

\item{shape2}{the second shape parameter(s) for the prior of each basket.
(default 0.5)}

\item{prior}{the matrix giving the prior inclusion probability
for each pair of baskets. The default is on on the main diagonal and 0.5
elsewhere.}

\item{hpd_alpha}{the highest posterior density trial significance.
(default 0.05)}

\item{alternative}{the alternative case definition (default "greater").}

\item{call}{the call of the function. (default NULL)}

\item{cluster_function}{a function to cluster baskets.}

\item{method}{"mcmc", "lmem" (local MEM),  or "exact". See details for an 
explanation.
(default "mcmc")}

\item{mcmc_iter}{if the method is "mcmc" then this spcifies the number of
mcmc iterations. Otherwise, it is ignored. (default 200000)}

\item{mcmc_burnin}{if the method is "mcmc" then this specifies the number of
burn-in iterations. (default 50000)}

\item{initial_mem}{if the method is "mcmc" then this spcifies the initial
MEM matrix. Otherwise, it is ignored.}

\item{cluster_analysis}{if the cluster analysis is conducted.}

\item{seed}{the random seed for the mcmc calculations. By default this is
.Random.seed. If this value is not initialized, then it is first initialized
with Sys.time() and then returned.}
}
\description{
This function creates an analysis modeling the exchangeability
and distribution characteristics of cohorts in a basket trial, where
a single therapy is given to multiple cohorts. The model is based on the
multi-source exchangeability model. This is a generalization of the
Bayesian hierarchical model and it accomodates multiple sets of latent
factors shared combinations of cohorts.
}
\details{
The model may be fit using an exact calculation via
mcmc, or a local version of MEM. The first conducts posterior inference 
through the entire set of
exchangeability relationships in the sample domain. This approach is
computationally feasible only when the number of cohorts is relatively
small. As a rule of thumb this option should be used with a maximum of
20 cohorts.  By default, the second(mcmc) is used and it is based on
the Metropolis algorithm and it extends the model's implementation to
larger collections of subpopulations. The algorithm initiates with a
burn-in period (see mcmc_burnin), which are discarded from the analysis.
The third is based on a recent paper by Wei et al. The calculation
is computationally efficient and tends to borrow to a lesser extent
than other implemented methods.
}
\examples{
\donttest{
# 3 baskets, each with enrollement size 5
trial_sizes <- rep(5, 3)

# The response rates for the baskets.
resp_rate <- 0.15

# The trials: a column of the number of responses and a column of the
# the size of each trial.
trials <- data.frame(
  responses = rbinom(trial_sizes, trial_sizes, resp_rate),
  size = trial_sizes,
  name = letters[1:3]
)

summary(basket(trials$responses, trials$size, trials$name))
}
}
