% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coltools.R
\name{num2col}
\alias{num2col}
\title{Numbers to Colors}
\usage{
num2col(x, pal, ref = range(x, na.rm = TRUE), NAcol)
}
\arguments{
\item{x}{numeric vector (factors are transformed to numeric)}

\item{pal}{colors used to build the palette (defaults to colors set by theme)}

\item{ref}{reference for assigning colors (defaults to the range of \code{x})}

\item{NAcol}{color to be used for NA values (defaults to color set by theme)}
}
\value{
a vector of colors for each element in \code{x} or, when \code{x} is missing, a function.
}
\description{
Assigns colors to the provided vector of numbers.
}
\details{
This function interpolates a given set of colors to a numeric vector.
Main use case is in turning numbers into colors for plots,
especially when different ranges of \code{x} have to be colored differently.

Color of NA values and values outside of \code{ref} range can be set using \code{NAcol} argument.
Set this to NA to omit the display of such values.

In case only a single color is provided - it is expanded by using tints and shades.

When \code{x} is not specified - a function that generates colors based on
\code{pal} and \code{ref} is returned.
}
\examples{
 # color numbers by y-axos
 plot(mtcars$hp, mtcars$mpg, col=num2col(mtcars$mpg), pch=19)

 # color only a certain range
 plot(mtcars$hp, mtcars$mpg, col=num2col(mtcars$mpg, ref=c(20, 35)), pch=19)

 # hide the out of range values
 plot(mtcars$hp, mtcars$mpg, col=num2col(mtcars$mpg, ref=c(20,35), NAcol=NA))

 # iris example
 pairs(iris[,-5], col=num2col(iris$Sepal.Length))

 # same butusing a prepared coloring function (for values in range 0-10)
 color <- num2col(ref=c(0,10))
 pairs(iris[,-5], col=color(iris$Sepal.Length))

}
\seealso{
\code{lab2col}
}
\author{
Karolis Koncevičius
}
