% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fastq_list.R
\name{read.fastq_to_list}
\alias{read.fastq_to_list}
\title{Read a Fastq file and store it as a list}
\usage{
read.fastq_to_list(fastq_file)
}
\arguments{
\item{fastq_file}{A character string specifying the path to the Fastq file to be read.}
}
\value{
This function returns a list with three columns: Header, Sequence, and QualityScore.
}
\description{
This function reads a Fastq file and stores it as a list with three columns: Header, Sequence, and QualityScore.
}
\examples{
\donttest{
# Read in sequences from a FASTQ file

sample_file_path_two <- system.file("extdata", "sample_fq.fastq", package = "baseq")
read.fastq_to_list(sample_file_path_two)
}
}
