% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenology-results.R
\name{get_onset_rst}
\alias{get_onset_rst}
\alias{get_onset_df}
\alias{get_diapause_rst}
\alias{get_diapause_df}
\alias{get_mortality_rst}
\alias{get_mortality_df}
\alias{get_events}
\alias{get_onset}
\alias{get_diapause}
\alias{get_mortality}
\title{Get onset, diapause or mortality}
\usage{
get_onset_rst(pheno, as_doy = TRUE, dates = prop_dates(pheno))

get_onset_df(
  pheno,
  stations = prop_stations(pheno),
  as_doy = TRUE,
  dates = prop_dates(pheno)
)

get_diapause_rst(pheno, as_doy = TRUE, dates = prop_dates(pheno))

get_diapause_df(
  pheno,
  stations = prop_stations(pheno),
  as_doy = TRUE,
  dates = prop_dates(pheno)
)

get_mortality_rst(pheno, as_doy = TRUE, dates = prop_dates(pheno))

get_mortality_df(
  pheno,
  stations = prop_stations(pheno),
  as_doy = TRUE,
  dates = prop_dates(pheno)
)
}
\arguments{
\item{pheno}{A  phenology (see \code{\link[=phenology]{phenology()}})}

\item{as_doy}{If \code{TRUE}, the day(s) of year will be returned. If \code{FALSE} the
phenological events will be returned in a raw format. Then, the return
value could be used as input for \code{\link[=phenology]{phenology()}}/\code{\link[=bso_phenology]{bso_phenology()}}
(parameters \code{.onset}, \code{.diapause} and \code{.mortality}).}

\item{dates}{Select dates that should be present in the output.}

\item{stations}{Pass a character vector to choose stations assigned to \code{pheno} by
their names, or pass different stations. See \code{\link[=stations_create]{stations_create()}} for details.}
}
\value{
\itemize{
\item \code{get_onset_rst()}, \code{get_diapause_rst()}, \code{get_mortality_rst()}: A
(multi-layer) SpatRaster.
\item \code{get_onset_df()}, \code{get_diapause_df()}, \code{get_mortality_df()}: A data frame.
}
}
\description{
Get onset, diapause or mortality as day of year or raw output. Note that
multiple mortality events are possible over the season.
}
\section{Functions}{
\itemize{
\item \code{get_onset_rst()}: Returns a (multi-layer) SpatRaster of the onset.

\item \code{get_onset_df()}: Returns a data frame of the onset.

\item \code{get_diapause_rst()}: Returns a (multi-layer) SpatRaster of the diapause.

\item \code{get_diapause_df()}: Returns a data frame of the diapause.

\item \code{get_mortality_rst()}: Returns a (multi-layer) SpatRaster of the mortality.

\item \code{get_mortality_df()}: Returns a data frame of the mortality.

}}
\examples{
\donttest{
# calculate phenology
p <- phenology('phenips-clim', barrks_data(), .quiet = TRUE)

# plot onset, diapause, mortality
get_onset_rst(p) |> terra::plot()
get_diapause_rst(p) |> terra::plot()
get_mortality_rst(p)[[1]] |> terra::plot()

}


}
