% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pam2richness.R
\name{pam2richness}
\alias{pam2richness}
\title{pam2richness: Converts Presence Absence Matrix (pam object) to
richness raster}
\usage{
pam2richness(pamobj, which_steps)
}
\arguments{
\item{pamobj}{An object of class pam see \code{\link[bamm]{csim2pam}}}

\item{which_steps}{Time steps in the pam to convert}
}
\value{
A RasterStack richness for each simulation step
}
\description{
Converts Presence Absence Matrix (pam object) to
richness raster
}
\examples{
\donttest{
lagos_path <- system.file("extdata/conejos",
                          package = "bamm")
enm_path <- list.files(lagos_path,
                       pattern = ".tif",
                    full.names = TRUE)[seq(1,10)]
en_models <- raster::stack(enm_path)
ngbs_vect <- sample(2,replace = TRUE,
                    size = raster::nlayers(en_models))
init_coords <- read.csv(file.path(lagos_path,
                                  "lagos_initit.csv"))[seq(1,10),]
nsteps <- 10
sdm_comm <- bamm::community_sim(en_models = en_models,
                                ngbs_vect = ngbs_vect,
                                init_coords = init_coords,
                                nsteps = nsteps,
                                threshold = 0.1)

pams <-bamm::csim2pam(community_sim = sdm_comm ,
                      which_steps = seq_len(nsteps))
richness_stack <- bamm::pam2richness(pamobj = pams,
                                     which_steps = pams@which_steps)
raster::plot(richness_stack)
}
}
\author{
Luis Osorio-Olvera & Jorge Soberón.
}
