// Generated by rstantools.  Do not edit by hand.

/*
    bakR is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    bakR is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with bakR.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_MCMC2_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 20, column 2 to column 49)",
                                                      " (in 'string', line 21, column 2 to column 39)",
                                                      " (in 'string', line 22, column 2 to column 30)",
                                                      " (in 'string', line 23, column 2 to column 24)",
                                                      " (in 'string', line 24, column 2 to column 34)",
                                                      " (in 'string', line 25, column 2 to column 33)",
                                                      " (in 'string', line 27, column 2 to column 25)",
                                                      " (in 'string', line 28, column 2 to column 16)",
                                                      " (in 'string', line 29, column 2 to column 32)",
                                                      " (in 'string', line 30, column 2 to column 31)",
                                                      " (in 'string', line 34, column 2 to column 54)",
                                                      " (in 'string', line 35, column 2 to column 44)",
                                                      " (in 'string', line 36, column 2 to column 39)",
                                                      " (in 'string', line 37, column 2 to column 41)",
                                                      " (in 'string', line 38, column 2 to column 31)",
                                                      " (in 'string', line 41, column 10 to column 70)",
                                                      " (in 'string', line 40, column 24 to line 42, column 9)",
                                                      " (in 'string', line 40, column 8 to line 42, column 9)",
                                                      " (in 'string', line 39, column 21 to line 43, column 7)",
                                                      " (in 'string', line 39, column 6 to line 43, column 7)",
                                                      " (in 'string', line 46, column 8 to column 50)",
                                                      " (in 'string', line 47, column 8 to column 66)",
                                                      " (in 'string', line 52, column 10 to column 75)",
                                                      " (in 'string', line 53, column 10 to column 64)",
                                                      " (in 'string', line 51, column 24 to line 54, column 9)",
                                                      " (in 'string', line 51, column 8 to line 54, column 9)",
                                                      " (in 'string', line 45, column 21 to line 55, column 7)",
                                                      " (in 'string', line 45, column 6 to line 55, column 7)",
                                                      " (in 'string', line 44, column 20 to line 56, column 7)",
                                                      " (in 'string', line 44, column 6 to line 56, column 7)",
                                                      " (in 'string', line 88, column 2 to column 27)",
                                                      " (in 'string', line 89, column 2 to column 34)",
                                                      " (in 'string', line 90, column 2 to column 31)",
                                                      " (in 'string', line 97, column 8 to column 54)",
                                                      " (in 'string', line 98, column 8 to column 35)",
                                                      " (in 'string', line 96, column 11 to line 99, column 7)",
                                                      " (in 'string', line 94, column 8 to column 52)",
                                                      " (in 'string', line 95, column 8 to column 35)",
                                                      " (in 'string', line 93, column 20 to line 96, column 7)",
                                                      " (in 'string', line 93, column 6 to line 99, column 7)",
                                                      " (in 'string', line 92, column 21 to line 100, column 5)",
                                                      " (in 'string', line 92, column 4 to line 100, column 5)",
                                                      " (in 'string', line 102, column 6 to column 45)",
                                                      " (in 'string', line 101, column 21 to line 103, column 5)",
                                                      " (in 'string', line 101, column 4 to line 103, column 5)",
                                                      " (in 'string', line 91, column 18 to line 104, column 3)",
                                                      " (in 'string', line 91, column 2 to line 104, column 3)",
                                                      " (in 'string', line 60, column 2 to column 26)",
                                                      " (in 'string', line 61, column 2 to column 30)",
                                                      " (in 'string', line 62, column 2 to column 23)",
                                                      " (in 'string', line 63, column 2 to column 25)",
                                                      " (in 'string', line 65, column 6 to column 46)",
                                                      " (in 'string', line 66, column 6 to column 51)",
                                                      " (in 'string', line 64, column 17 to line 67, column 3)",
                                                      " (in 'string', line 64, column 2 to line 67, column 3)",
                                                      " (in 'string', line 68, column 2 to column 31)",
                                                      " (in 'string', line 72, column 4 to column 28)",
                                                      " (in 'string', line 74, column 8 to column 49)",
                                                      " (in 'string', line 76, column 8 to column 33)",
                                                      " (in 'string', line 73, column 19 to line 78, column 5)",
                                                      " (in 'string', line 73, column 4 to line 78, column 5)",
                                                      " (in 'string', line 69, column 18 to line 79, column 3)",
                                                      " (in 'string', line 69, column 2 to line 79, column 3)",
                                                      " (in 'string', line 82, column 4 to line 84, column 107)",
                                                      " (in 'string', line 81, column 18 to line 85, column 3)",
                                                      " (in 'string', line 81, column 2 to line 85, column 3)",
                                                      " (in 'string', line 3, column 2 to column 9)",
                                                      " (in 'string', line 4, column 2 to column 9)",
                                                      " (in 'string', line 5, column 8 to column 10)",
                                                      " (in 'string', line 5, column 2 to column 19)",
                                                      " (in 'string', line 6, column 8 to column 10)",
                                                      " (in 'string', line 6, column 2 to column 19)",
                                                      " (in 'string', line 7, column 2 to column 10)",
                                                      " (in 'string', line 8, column 8 to column 10)",
                                                      " (in 'string', line 8, column 2 to column 19)",
                                                      " (in 'string', line 9, column 8 to column 10)",
                                                      " (in 'string', line 9, column 2 to column 24)",
                                                      " (in 'string', line 10, column 8 to column 10)",
                                                      " (in 'string', line 10, column 2 to column 24)",
                                                      " (in 'string', line 11, column 8 to column 10)",
                                                      " (in 'string', line 11, column 2 to column 18)",
                                                      " (in 'string', line 12, column 8 to column 10)",
                                                      " (in 'string', line 12, column 2 to column 24)",
                                                      " (in 'string', line 13, column 2 to column 11)",
                                                      " (in 'string', line 14, column 8 to column 11)",
                                                      " (in 'string', line 14, column 2 to column 21)",
                                                      " (in 'string', line 15, column 8 to column 10)",
                                                      " (in 'string', line 15, column 12 to column 15)",
                                                      " (in 'string', line 15, column 2 to column 32)",
                                                      " (in 'string', line 16, column 2 to column 34)",
                                                      " (in 'string', line 17, column 2 to column 10)",
                                                      " (in 'string', line 20, column 8 to column 11)",
                                                      " (in 'string', line 20, column 29 to column 33)",
                                                      " (in 'string', line 21, column 8 to column 11)",
                                                      " (in 'string', line 21, column 20 to column 24)",
                                                      " (in 'string', line 22, column 8 to column 10)",
                                                      " (in 'string', line 22, column 19 to column 22)",
                                                      " (in 'string', line 23, column 8 to column 11)",
                                                      " (in 'string', line 24, column 8 to column 11)",
                                                      " (in 'string', line 25, column 8 to column 10)",
                                                      " (in 'string', line 25, column 12 to column 15)",
                                                      " (in 'string', line 25, column 17 to column 21)",
                                                      " (in 'string', line 27, column 18 to column 21)",
                                                      " (in 'string', line 28, column 9 to column 12)",
                                                      " (in 'string', line 29, column 8 to column 10)",
                                                      " (in 'string', line 29, column 19 to column 22)",
                                                      " (in 'string', line 30, column 18 to column 21)",
                                                      " (in 'string', line 34, column 8 to column 10)",
                                                      " (in 'string', line 34, column 12 to column 15)",
                                                      " (in 'string', line 34, column 17 to column 21)",
                                                      " (in 'string', line 35, column 8 to column 10)",
                                                      " (in 'string', line 35, column 12 to column 15)",
                                                      " (in 'string', line 35, column 17 to column 21)",
                                                      " (in 'string', line 36, column 8 to column 11)",
                                                      " (in 'string', line 36, column 20 to column 24)",
                                                      " (in 'string', line 37, column 8 to column 10)",
                                                      " (in 'string', line 37, column 28 to column 31)",
                                                      " (in 'string', line 38, column 8 to column 10)",
                                                      " (in 'string', line 38, column 19 to column 22)",
                                                      " (in 'string', line 88, column 8 to column 10)",
                                                      " (in 'string', line 88, column 19 to column 22)",
                                                      " (in 'string', line 89, column 8 to column 10)",
                                                      " (in 'string', line 89, column 19 to column 24)",
                                                      " (in 'string', line 90, column 8 to column 10)",
                                                      " (in 'string', line 90, column 19 to column 22)"};
#include <stan_meta_header.hpp>
class model_MCMC2 final : public model_base_crtp<model_MCMC2> {
private:
  int NE;
  int NF;
  std::vector<int> TP;
  std::vector<int> MT;
  int nMT;
  std::vector<int> FE;
  std::vector<int> num_mut;
  std::vector<int> num_obs;
  std::vector<int> R;
  std::vector<double> U_cont;
  int nrep;
  std::vector<double> tl;
  std::vector<std::vector<double>> Avg_Reads;
  int Chase;
  double nU;
  int L2FC_kd_2dim__;
 
public:
  ~model_MCMC2() { }
  
  inline std::string model_name() const final { return "model_MCMC2"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_MCMC2(stan::io::var_context& context__,
              unsigned int random_seed__ = 0,
              std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_MCMC2_namespace::model_MCMC2";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 67;
      context__.validate_dims("data initialization","NE","int",
          context__.to_vec());
      NE = std::numeric_limits<int>::min();
      
      current_statement__ = 67;
      NE = context__.vals_i("NE")[(1 - 1)];
      current_statement__ = 68;
      context__.validate_dims("data initialization","NF","int",
          context__.to_vec());
      NF = std::numeric_limits<int>::min();
      
      current_statement__ = 68;
      NF = context__.vals_i("NF")[(1 - 1)];
      current_statement__ = 69;
      validate_non_negative_index("TP", "NE", NE);
      current_statement__ = 70;
      context__.validate_dims("data initialization","TP","int",
          context__.to_vec(NE));
      TP = std::vector<int>(NE, std::numeric_limits<int>::min());
      
      current_statement__ = 70;
      assign(TP, nil_index_list(), context__.vals_i("TP"),
        "assigning variable TP");
      current_statement__ = 71;
      validate_non_negative_index("MT", "NE", NE);
      current_statement__ = 72;
      context__.validate_dims("data initialization","MT","int",
          context__.to_vec(NE));
      MT = std::vector<int>(NE, std::numeric_limits<int>::min());
      
      current_statement__ = 72;
      assign(MT, nil_index_list(), context__.vals_i("MT"),
        "assigning variable MT");
      current_statement__ = 73;
      context__.validate_dims("data initialization","nMT","int",
          context__.to_vec());
      nMT = std::numeric_limits<int>::min();
      
      current_statement__ = 73;
      nMT = context__.vals_i("nMT")[(1 - 1)];
      current_statement__ = 74;
      validate_non_negative_index("FE", "NE", NE);
      current_statement__ = 75;
      context__.validate_dims("data initialization","FE","int",
          context__.to_vec(NE));
      FE = std::vector<int>(NE, std::numeric_limits<int>::min());
      
      current_statement__ = 75;
      assign(FE, nil_index_list(), context__.vals_i("FE"),
        "assigning variable FE");
      current_statement__ = 76;
      validate_non_negative_index("num_mut", "NE", NE);
      current_statement__ = 77;
      context__.validate_dims("data initialization","num_mut","int",
          context__.to_vec(NE));
      num_mut = std::vector<int>(NE, std::numeric_limits<int>::min());
      
      current_statement__ = 77;
      assign(num_mut, nil_index_list(), context__.vals_i("num_mut"),
        "assigning variable num_mut");
      current_statement__ = 78;
      validate_non_negative_index("num_obs", "NE", NE);
      current_statement__ = 79;
      context__.validate_dims("data initialization","num_obs","int",
          context__.to_vec(NE));
      num_obs = std::vector<int>(NE, std::numeric_limits<int>::min());
      
      current_statement__ = 79;
      assign(num_obs, nil_index_list(), context__.vals_i("num_obs"),
        "assigning variable num_obs");
      current_statement__ = 80;
      validate_non_negative_index("R", "NE", NE);
      current_statement__ = 81;
      context__.validate_dims("data initialization","R","int",
          context__.to_vec(NE));
      R = std::vector<int>(NE, std::numeric_limits<int>::min());
      
      current_statement__ = 81;
      assign(R, nil_index_list(), context__.vals_i("R"),
        "assigning variable R");
      current_statement__ = 82;
      validate_non_negative_index("U_cont", "NE", NE);
      current_statement__ = 83;
      context__.validate_dims("data initialization","U_cont","double",
          context__.to_vec(NE));
      U_cont = std::vector<double>(NE, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 83;
      assign(U_cont, nil_index_list(), context__.vals_r("U_cont"),
        "assigning variable U_cont");
      current_statement__ = 84;
      context__.validate_dims("data initialization","nrep","int",
          context__.to_vec());
      nrep = std::numeric_limits<int>::min();
      
      current_statement__ = 84;
      nrep = context__.vals_i("nrep")[(1 - 1)];
      current_statement__ = 85;
      validate_non_negative_index("tl", "nMT", nMT);
      current_statement__ = 86;
      context__.validate_dims("data initialization","tl","double",
          context__.to_vec(nMT));
      tl = std::vector<double>(nMT, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 86;
      assign(tl, nil_index_list(), context__.vals_r("tl"),
        "assigning variable tl");
      current_statement__ = 87;
      validate_non_negative_index("Avg_Reads", "NF", NF);
      current_statement__ = 88;
      validate_non_negative_index("Avg_Reads", "nMT", nMT);
      current_statement__ = 89;
      context__.validate_dims("data initialization","Avg_Reads","double",
          context__.to_vec(NF, nMT));
      Avg_Reads = std::vector<std::vector<double>>(NF, std::vector<double>(nMT, std::numeric_limits<double>::quiet_NaN()));
      
      {
        std::vector<local_scalar_t__> Avg_Reads_flat__;
        current_statement__ = 89;
        assign(Avg_Reads_flat__, nil_index_list(),
          context__.vals_r("Avg_Reads"),
          "assigning variable Avg_Reads_flat__");
        current_statement__ = 89;
        pos__ = 1;
        current_statement__ = 89;
        for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
          current_statement__ = 89;
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            current_statement__ = 89;
            assign(Avg_Reads,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              Avg_Reads_flat__[(pos__ - 1)], "assigning variable Avg_Reads");
            current_statement__ = 89;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 90;
      context__.validate_dims("data initialization","Chase","int",
          context__.to_vec());
      Chase = std::numeric_limits<int>::min();
      
      current_statement__ = 90;
      Chase = context__.vals_i("Chase")[(1 - 1)];
      current_statement__ = 90;
      current_statement__ = 90;
      check_greater_or_equal(function__, "Chase", Chase, 0);
      current_statement__ = 90;
      current_statement__ = 90;
      check_less_or_equal(function__, "Chase", Chase, 1);
      current_statement__ = 91;
      context__.validate_dims("data initialization","nU","double",
          context__.to_vec());
      nU = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 91;
      nU = context__.vals_r("nU")[(1 - 1)];
      current_statement__ = 92;
      validate_non_negative_index("TL_lambda_eff", "nMT", nMT);
      current_statement__ = 93;
      validate_non_negative_index("TL_lambda_eff", "nrep", nrep);
      current_statement__ = 94;
      validate_non_negative_index("log_lambda_o", "nMT", nMT);
      current_statement__ = 95;
      validate_non_negative_index("log_lambda_o", "nrep", nrep);
      current_statement__ = 96;
      validate_non_negative_index("alpha", "NF", NF);
      current_statement__ = 97;
      validate_non_negative_index("alpha", "nMT", nMT);
      current_statement__ = 98;
      validate_non_negative_index("mu_fn", "nMT", nMT);
      current_statement__ = 99;
      validate_non_negative_index("sig_fn", "nMT", nMT);
      current_statement__ = 100;
      validate_non_negative_index("z_fn", "NF", NF);
      current_statement__ = 101;
      validate_non_negative_index("z_fn", "nMT", nMT);
      current_statement__ = 102;
      validate_non_negative_index("z_fn", "nrep", nrep);
      current_statement__ = 103;
      validate_non_negative_index("a", "nMT", nMT);
      current_statement__ = 104;
      validate_non_negative_index("b", "nMT", nMT);
      current_statement__ = 105;
      validate_non_negative_index("z_sd_r", "NF", NF);
      current_statement__ = 106;
      validate_non_negative_index("z_sd_r", "nMT", nMT);
      current_statement__ = 107;
      validate_non_negative_index("sig_rep", "nMT", nMT);
      current_statement__ = 108;
      validate_non_negative_index("frac_new", "NF", NF);
      current_statement__ = 109;
      validate_non_negative_index("frac_new", "nMT", nMT);
      current_statement__ = 110;
      validate_non_negative_index("frac_new", "nrep", nrep);
      current_statement__ = 111;
      validate_non_negative_index("mu_rep_logit_fn", "NF", NF);
      current_statement__ = 112;
      validate_non_negative_index("mu_rep_logit_fn", "nMT", nMT);
      current_statement__ = 113;
      validate_non_negative_index("mu_rep_logit_fn", "nrep", nrep);
      current_statement__ = 114;
      validate_non_negative_index("log_lambda_n", "nMT", nMT);
      current_statement__ = 115;
      validate_non_negative_index("log_lambda_n", "nrep", nrep);
      current_statement__ = 116;
      validate_non_negative_index("sd_r_mu", "NF", NF);
      current_statement__ = 117;
      validate_non_negative_index("sd_r_mu", "nMT", nMT);
      current_statement__ = 118;
      validate_non_negative_index("sd_rep", "NF", NF);
      current_statement__ = 119;
      validate_non_negative_index("sd_rep", "nMT", nMT);
      current_statement__ = 120;
      validate_non_negative_index("kd", "NF", NF);
      current_statement__ = 121;
      validate_non_negative_index("kd", "nMT", nMT);
      current_statement__ = 122;
      validate_non_negative_index("L2FC_kd", "NF", NF);
      current_statement__ = 123;
      L2FC_kd_2dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 123;
      L2FC_kd_2dim__ = (nMT - 1);
      current_statement__ = 123;
      validate_non_negative_index("L2FC_kd", "nMT - 1", L2FC_kd_2dim__);
      current_statement__ = 124;
      validate_non_negative_index("log_kd", "NF", NF);
      current_statement__ = 125;
      validate_non_negative_index("log_kd", "nMT", nMT);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += nMT * nrep;
      num_params_r__ += nMT * nrep;
      num_params_r__ += NF * nMT;
      num_params_r__ += nMT;
      num_params_r__ += nMT;
      num_params_r__ += NF * nMT * nrep;
      num_params_r__ += nMT;
      num_params_r__ += nMT;
      num_params_r__ += NF * nMT;
      num_params_r__ += nMT;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_MCMC2_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> TL_lambda_eff;
      TL_lambda_eff = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(nMT, Eigen::Matrix<local_scalar_t__, -1, 1>(nrep));
      stan::math::fill(TL_lambda_eff, DUMMY_VAR__);
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 1;
        assign(TL_lambda_eff, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nrep), "assigning variable TL_lambda_eff");}
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 1;
        for (int sym2__ = 1; sym2__ <= nrep; ++sym2__) {
          current_statement__ = 1;
          if (jacobian__) {
            current_statement__ = 1;
            assign(TL_lambda_eff,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lb_constrain(
                TL_lambda_eff[(sym1__ - 1)][(sym2__ - 1)], 0, lp__),
              "assigning variable TL_lambda_eff");
          } else {
            current_statement__ = 1;
            assign(TL_lambda_eff,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lb_constrain(
                TL_lambda_eff[(sym1__ - 1)][(sym2__ - 1)], 0),
              "assigning variable TL_lambda_eff");
          }}}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> log_lambda_o;
      log_lambda_o = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(nMT, Eigen::Matrix<local_scalar_t__, -1, 1>(nrep));
      stan::math::fill(log_lambda_o, DUMMY_VAR__);
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 2;
        assign(log_lambda_o, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nrep), "assigning variable log_lambda_o");}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> alpha;
      alpha = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(NF, Eigen::Matrix<local_scalar_t__, -1, 1>(nMT));
      stan::math::fill(alpha, DUMMY_VAR__);
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= NF; ++sym1__) {
        current_statement__ = 3;
        assign(alpha, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nMT), "assigning variable alpha");}
      std::vector<local_scalar_t__> mu_fn;
      mu_fn = std::vector<local_scalar_t__>(nMT, DUMMY_VAR__);
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 4;
        assign(mu_fn, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable mu_fn");}
      std::vector<local_scalar_t__> sig_fn;
      sig_fn = std::vector<local_scalar_t__>(nMT, DUMMY_VAR__);
      
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 5;
        assign(sig_fn, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sig_fn");}
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 5;
        if (jacobian__) {
          current_statement__ = 5;
          assign(sig_fn, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sig_fn[(sym1__ - 1)], 0, lp__),
            "assigning variable sig_fn");
        } else {
          current_statement__ = 5;
          assign(sig_fn, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sig_fn[(sym1__ - 1)], 0),
            "assigning variable sig_fn");
        }}
      std::vector<std::vector<std::vector<local_scalar_t__>>> z_fn;
      z_fn = std::vector<std::vector<std::vector<local_scalar_t__>>>(NF, std::vector<std::vector<local_scalar_t__>>(nMT, std::vector<local_scalar_t__>(nrep, DUMMY_VAR__)));
      
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= NF; ++sym1__) {
        current_statement__ = 6;
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          current_statement__ = 6;
          for (int sym3__ = 1; sym3__ <= nrep; ++sym3__) {
            current_statement__ = 6;
            assign(z_fn,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym3__), nil_index_list()))),
              in__.scalar(), "assigning variable z_fn");}}}
      Eigen::Matrix<local_scalar_t__, -1, 1> a;
      a = Eigen::Matrix<local_scalar_t__, -1, 1>(nMT);
      stan::math::fill(a, DUMMY_VAR__);
      
      current_statement__ = 7;
      a = in__.vector(nMT);
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 7;
        if (jacobian__) {
          current_statement__ = 7;
          assign(a, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(a[(sym1__ - 1)], 0, lp__),
            "assigning variable a");
        } else {
          current_statement__ = 7;
          assign(a, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(a[(sym1__ - 1)], 0),
            "assigning variable a");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> b;
      b = Eigen::Matrix<local_scalar_t__, -1, 1>(nMT);
      stan::math::fill(b, DUMMY_VAR__);
      
      current_statement__ = 8;
      b = in__.vector(nMT);
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> z_sd_r;
      z_sd_r = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(NF, Eigen::Matrix<local_scalar_t__, -1, 1>(nMT));
      stan::math::fill(z_sd_r, DUMMY_VAR__);
      
      current_statement__ = 9;
      for (int sym1__ = 1; sym1__ <= NF; ++sym1__) {
        current_statement__ = 9;
        assign(z_sd_r, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nMT), "assigning variable z_sd_r");}
      Eigen::Matrix<local_scalar_t__, -1, 1> sig_rep;
      sig_rep = Eigen::Matrix<local_scalar_t__, -1, 1>(nMT);
      stan::math::fill(sig_rep, DUMMY_VAR__);
      
      current_statement__ = 10;
      sig_rep = in__.vector(nMT);
      current_statement__ = 10;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 10;
        if (jacobian__) {
          current_statement__ = 10;
          assign(sig_rep, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sig_rep[(sym1__ - 1)], 0, lp__),
            "assigning variable sig_rep");
        } else {
          current_statement__ = 10;
          assign(sig_rep, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sig_rep[(sym1__ - 1)], 0),
            "assigning variable sig_rep");
        }}
      std::vector<std::vector<std::vector<local_scalar_t__>>> frac_new;
      frac_new = std::vector<std::vector<std::vector<local_scalar_t__>>>(NF, std::vector<std::vector<local_scalar_t__>>(nMT, std::vector<local_scalar_t__>(nrep, DUMMY_VAR__)));
      
      std::vector<std::vector<std::vector<local_scalar_t__>>> mu_rep_logit_fn;
      mu_rep_logit_fn = std::vector<std::vector<std::vector<local_scalar_t__>>>(NF, std::vector<std::vector<local_scalar_t__>>(nMT, std::vector<local_scalar_t__>(nrep, DUMMY_VAR__)));
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> log_lambda_n;
      log_lambda_n = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(nMT, Eigen::Matrix<local_scalar_t__, -1, 1>(nrep));
      stan::math::fill(log_lambda_n, DUMMY_VAR__);
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> sd_r_mu;
      sd_r_mu = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(NF, Eigen::Matrix<local_scalar_t__, -1, 1>(nMT));
      stan::math::fill(sd_r_mu, DUMMY_VAR__);
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> sd_rep;
      sd_rep = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(NF, Eigen::Matrix<local_scalar_t__, -1, 1>(nMT));
      stan::math::fill(sd_rep, DUMMY_VAR__);
      
      current_statement__ = 20;
      for (int m = 1; m <= nMT; ++m) {
        current_statement__ = 18;
        for (int r = 1; r <= nrep; ++r) {
          current_statement__ = 16;
          assign(log_lambda_n,
            cons_list(index_uni(m),
              cons_list(index_uni(r), nil_index_list())),
            (log_lambda_o[(m - 1)][(r - 1)] +
              TL_lambda_eff[(m - 1)][(r - 1)]),
            "assigning variable log_lambda_n");}}
      current_statement__ = 30;
      for (int i = 1; i <= NF; ++i) {
        current_statement__ = 28;
        for (int j = 1; j <= nMT; ++j) {
          current_statement__ = 21;
          assign(sd_rep,
            cons_list(index_uni(i),
              cons_list(index_uni(j), nil_index_list())),
            ((-a[(j - 1)] * Avg_Reads[(i - 1)][(j - 1)]) + b[(j - 1)]),
            "assigning variable sd_rep");
          current_statement__ = 22;
          assign(sd_r_mu,
            cons_list(index_uni(i),
              cons_list(index_uni(j), nil_index_list())),
            stan::math::exp(
              (sd_rep[(i - 1)][(j - 1)] +
                (z_sd_r[(i - 1)][(j - 1)] * sig_rep[(j - 1)]))),
            "assigning variable sd_r_mu");
          current_statement__ = 26;
          for (int k = 1; k <= nrep; ++k) {
            current_statement__ = 23;
            assign(mu_rep_logit_fn,
              cons_list(index_uni(i),
                cons_list(index_uni(j),
                  cons_list(index_uni(k), nil_index_list()))),
              (alpha[(i - 1)][(j - 1)] +
                (sd_r_mu[(i - 1)][(j - 1)] * z_fn[(i - 1)][(j - 1)][(k - 1)])),
              "assigning variable mu_rep_logit_fn");
            current_statement__ = 24;
            assign(frac_new,
              cons_list(index_uni(i),
                cons_list(index_uni(j),
                  cons_list(index_uni(k), nil_index_list()))),
              inv_logit(mu_rep_logit_fn[(i - 1)][(j - 1)][(k - 1)]),
              "assigning variable frac_new");}}}
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= NF; ++sym1__) {
        current_statement__ = 11;
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          current_statement__ = 11;
          for (int sym3__ = 1; sym3__ <= nrep; ++sym3__) {
            current_statement__ = 11;
            current_statement__ = 11;
            check_greater_or_equal(function__,
                                   "frac_new[sym1__, sym2__, sym3__]",
                                   frac_new[(sym1__ - 1)][(sym2__ - 1)][
                                   (sym3__ - 1)], 0);}}}
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= NF; ++sym1__) {
        current_statement__ = 11;
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          current_statement__ = 11;
          for (int sym3__ = 1; sym3__ <= nrep; ++sym3__) {
            current_statement__ = 11;
            current_statement__ = 11;
            check_less_or_equal(function__,
                                "frac_new[sym1__, sym2__, sym3__]",
                                frac_new[(sym1__ - 1)][(sym2__ - 1)][
                                (sym3__ - 1)], 1);}}}
      current_statement__ = 14;
      for (int sym1__ = 1; sym1__ <= NF; ++sym1__) {
        current_statement__ = 14;
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          current_statement__ = 14;
          current_statement__ = 14;
          check_greater_or_equal(function__, "sd_r_mu[sym1__, sym2__]",
                                 sd_r_mu[(sym1__ - 1)][(sym2__ - 1)], 0);}}
      {
        current_statement__ = 48;
        lp_accum__.add(normal_lpdf<propto__>(mu_fn, 0, 1.25));
        current_statement__ = 49;
        lp_accum__.add(lognormal_lpdf<propto__>(sig_fn, -1, 0.5));
        current_statement__ = 50;
        lp_accum__.add(normal_lpdf<propto__>(a, 0.3, 0.2));
        current_statement__ = 51;
        lp_accum__.add(normal_lpdf<propto__>(b, -1.5, 0.35));
        current_statement__ = 55;
        for (int m = 1; m <= nMT; ++m) {
          current_statement__ = 52;
          lp_accum__.add(
            lognormal_lpdf<propto__>(TL_lambda_eff[(m - 1)], 1.4, 0.15));
          current_statement__ = 53;
          lp_accum__.add(
            normal_lpdf<propto__>(log_lambda_o[(m - 1)],
              stan::math::log((0.001 * nU)), 0.5));}
        current_statement__ = 56;
        lp_accum__.add(lognormal_lpdf<propto__>(sig_rep, -2, 0.25));
        current_statement__ = 63;
        for (int i = 1; i <= NF; ++i) {
          current_statement__ = 57;
          lp_accum__.add(normal_lpdf<propto__>(z_sd_r[(i - 1)], 0, 1));
          current_statement__ = 61;
          for (int j = 1; j <= nMT; ++j) {
            current_statement__ = 58;
            lp_accum__.add(
              normal_lpdf<propto__>(alpha[(i - 1)][(j - 1)], mu_fn[(j - 1)],
                sig_fn[(j - 1)]));
            current_statement__ = 59;
            lp_accum__.add(
              normal_lpdf<propto__>(z_fn[(i - 1)][(j - 1)], 0, 1));}}
        current_statement__ = 66;
        for (int i = 1; i <= NE; ++i) {
          current_statement__ = 64;
          lp_accum__.add(
            (num_obs[(i - 1)] *
              log_mix(
                (TP[(i - 1)] *
                  frac_new[(FE[(i - 1)] - 1)][(MT[(i - 1)] - 1)][(R[(i - 1)]
                                                                   - 1)]),
                poisson_log_lpmf<false>(num_mut[(i - 1)],
                  (U_cont[(i - 1)] +
                    log_lambda_n[(MT[(i - 1)] - 1)][(R[(i - 1)] - 1)])),
                poisson_log_lpmf<false>(num_mut[(i - 1)],
                  (U_cont[(i - 1)] +
                    log_lambda_o[(MT[(i - 1)] - 1)][(R[(i - 1)] - 1)])))));}
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_MCMC2_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<Eigen::Matrix<double, -1, 1>> TL_lambda_eff;
      TL_lambda_eff = std::vector<Eigen::Matrix<double, -1, 1>>(nMT, Eigen::Matrix<double, -1, 1>(nrep));
      stan::math::fill(TL_lambda_eff, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 1;
        assign(TL_lambda_eff, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nrep), "assigning variable TL_lambda_eff");}
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 1;
        for (int sym2__ = 1; sym2__ <= nrep; ++sym2__) {
          current_statement__ = 1;
          assign(TL_lambda_eff,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lb_constrain(
              TL_lambda_eff[(sym1__ - 1)][(sym2__ - 1)], 0),
            "assigning variable TL_lambda_eff");}}
      std::vector<Eigen::Matrix<double, -1, 1>> log_lambda_o;
      log_lambda_o = std::vector<Eigen::Matrix<double, -1, 1>>(nMT, Eigen::Matrix<double, -1, 1>(nrep));
      stan::math::fill(log_lambda_o, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 2;
        assign(log_lambda_o, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nrep), "assigning variable log_lambda_o");}
      std::vector<Eigen::Matrix<double, -1, 1>> alpha;
      alpha = std::vector<Eigen::Matrix<double, -1, 1>>(NF, Eigen::Matrix<double, -1, 1>(nMT));
      stan::math::fill(alpha, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= NF; ++sym1__) {
        current_statement__ = 3;
        assign(alpha, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nMT), "assigning variable alpha");}
      std::vector<double> mu_fn;
      mu_fn = std::vector<double>(nMT, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 4;
        assign(mu_fn, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable mu_fn");}
      std::vector<double> sig_fn;
      sig_fn = std::vector<double>(nMT, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 5;
        assign(sig_fn, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sig_fn");}
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 5;
        assign(sig_fn, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(sig_fn[(sym1__ - 1)], 0),
          "assigning variable sig_fn");}
      std::vector<std::vector<std::vector<double>>> z_fn;
      z_fn = std::vector<std::vector<std::vector<double>>>(NF, std::vector<std::vector<double>>(nMT, std::vector<double>(nrep, std::numeric_limits<double>::quiet_NaN())));
      
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= NF; ++sym1__) {
        current_statement__ = 6;
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          current_statement__ = 6;
          for (int sym3__ = 1; sym3__ <= nrep; ++sym3__) {
            current_statement__ = 6;
            assign(z_fn,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym3__), nil_index_list()))),
              in__.scalar(), "assigning variable z_fn");}}}
      Eigen::Matrix<double, -1, 1> a;
      a = Eigen::Matrix<double, -1, 1>(nMT);
      stan::math::fill(a, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 7;
      a = in__.vector(nMT);
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 7;
        assign(a, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(a[(sym1__ - 1)], 0),
          "assigning variable a");}
      Eigen::Matrix<double, -1, 1> b;
      b = Eigen::Matrix<double, -1, 1>(nMT);
      stan::math::fill(b, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 8;
      b = in__.vector(nMT);
      std::vector<Eigen::Matrix<double, -1, 1>> z_sd_r;
      z_sd_r = std::vector<Eigen::Matrix<double, -1, 1>>(NF, Eigen::Matrix<double, -1, 1>(nMT));
      stan::math::fill(z_sd_r, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 9;
      for (int sym1__ = 1; sym1__ <= NF; ++sym1__) {
        current_statement__ = 9;
        assign(z_sd_r, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nMT), "assigning variable z_sd_r");}
      Eigen::Matrix<double, -1, 1> sig_rep;
      sig_rep = Eigen::Matrix<double, -1, 1>(nMT);
      stan::math::fill(sig_rep, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 10;
      sig_rep = in__.vector(nMT);
      current_statement__ = 10;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 10;
        assign(sig_rep, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(sig_rep[(sym1__ - 1)], 0),
          "assigning variable sig_rep");}
      std::vector<std::vector<std::vector<double>>> frac_new;
      frac_new = std::vector<std::vector<std::vector<double>>>(NF, std::vector<std::vector<double>>(nMT, std::vector<double>(nrep, std::numeric_limits<double>::quiet_NaN())));
      
      std::vector<std::vector<std::vector<double>>> mu_rep_logit_fn;
      mu_rep_logit_fn = std::vector<std::vector<std::vector<double>>>(NF, std::vector<std::vector<double>>(nMT, std::vector<double>(nrep, std::numeric_limits<double>::quiet_NaN())));
      
      std::vector<Eigen::Matrix<double, -1, 1>> log_lambda_n;
      log_lambda_n = std::vector<Eigen::Matrix<double, -1, 1>>(nMT, Eigen::Matrix<double, -1, 1>(nrep));
      stan::math::fill(log_lambda_n, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> sd_r_mu;
      sd_r_mu = std::vector<Eigen::Matrix<double, -1, 1>>(NF, Eigen::Matrix<double, -1, 1>(nMT));
      stan::math::fill(sd_r_mu, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> sd_rep;
      sd_rep = std::vector<Eigen::Matrix<double, -1, 1>>(NF, Eigen::Matrix<double, -1, 1>(nMT));
      stan::math::fill(sd_rep, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          vars__.emplace_back(TL_lambda_eff[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          vars__.emplace_back(log_lambda_o[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
          vars__.emplace_back(alpha[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        vars__.emplace_back(mu_fn[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        vars__.emplace_back(sig_fn[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= NF; ++sym3__) {
            vars__.emplace_back(
              z_fn[(sym3__ - 1)][(sym2__ - 1)][(sym1__ - 1)]);}}}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        vars__.emplace_back(a[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        vars__.emplace_back(b[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
          vars__.emplace_back(z_sd_r[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        vars__.emplace_back(sig_rep[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 20;
      for (int m = 1; m <= nMT; ++m) {
        current_statement__ = 18;
        for (int r = 1; r <= nrep; ++r) {
          current_statement__ = 16;
          assign(log_lambda_n,
            cons_list(index_uni(m),
              cons_list(index_uni(r), nil_index_list())),
            (log_lambda_o[(m - 1)][(r - 1)] +
              TL_lambda_eff[(m - 1)][(r - 1)]),
            "assigning variable log_lambda_n");}}
      current_statement__ = 30;
      for (int i = 1; i <= NF; ++i) {
        current_statement__ = 28;
        for (int j = 1; j <= nMT; ++j) {
          current_statement__ = 21;
          assign(sd_rep,
            cons_list(index_uni(i),
              cons_list(index_uni(j), nil_index_list())),
            ((-a[(j - 1)] * Avg_Reads[(i - 1)][(j - 1)]) + b[(j - 1)]),
            "assigning variable sd_rep");
          current_statement__ = 22;
          assign(sd_r_mu,
            cons_list(index_uni(i),
              cons_list(index_uni(j), nil_index_list())),
            stan::math::exp(
              (sd_rep[(i - 1)][(j - 1)] +
                (z_sd_r[(i - 1)][(j - 1)] * sig_rep[(j - 1)]))),
            "assigning variable sd_r_mu");
          current_statement__ = 26;
          for (int k = 1; k <= nrep; ++k) {
            current_statement__ = 23;
            assign(mu_rep_logit_fn,
              cons_list(index_uni(i),
                cons_list(index_uni(j),
                  cons_list(index_uni(k), nil_index_list()))),
              (alpha[(i - 1)][(j - 1)] +
                (sd_r_mu[(i - 1)][(j - 1)] * z_fn[(i - 1)][(j - 1)][(k - 1)])),
              "assigning variable mu_rep_logit_fn");
            current_statement__ = 24;
            assign(frac_new,
              cons_list(index_uni(i),
                cons_list(index_uni(j),
                  cons_list(index_uni(k), nil_index_list()))),
              inv_logit(mu_rep_logit_fn[(i - 1)][(j - 1)][(k - 1)]),
              "assigning variable frac_new");}}}
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= NF; ++sym1__) {
        current_statement__ = 11;
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          current_statement__ = 11;
          for (int sym3__ = 1; sym3__ <= nrep; ++sym3__) {
            current_statement__ = 11;
            current_statement__ = 11;
            check_greater_or_equal(function__,
                                   "frac_new[sym1__, sym2__, sym3__]",
                                   frac_new[(sym1__ - 1)][(sym2__ - 1)][
                                   (sym3__ - 1)], 0);}}}
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= NF; ++sym1__) {
        current_statement__ = 11;
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          current_statement__ = 11;
          for (int sym3__ = 1; sym3__ <= nrep; ++sym3__) {
            current_statement__ = 11;
            current_statement__ = 11;
            check_less_or_equal(function__,
                                "frac_new[sym1__, sym2__, sym3__]",
                                frac_new[(sym1__ - 1)][(sym2__ - 1)][
                                (sym3__ - 1)], 1);}}}
      current_statement__ = 14;
      for (int sym1__ = 1; sym1__ <= NF; ++sym1__) {
        current_statement__ = 14;
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          current_statement__ = 14;
          current_statement__ = 14;
          check_greater_or_equal(function__, "sd_r_mu[sym1__, sym2__]",
                                 sd_r_mu[(sym1__ - 1)][(sym2__ - 1)], 0);}}
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
            for (int sym3__ = 1; sym3__ <= NF; ++sym3__) {
              vars__.emplace_back(
                frac_new[(sym3__ - 1)][(sym2__ - 1)][(sym1__ - 1)]);}}}
        for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
            for (int sym3__ = 1; sym3__ <= NF; ++sym3__) {
              vars__.emplace_back(
                mu_rep_logit_fn[(sym3__ - 1)][(sym2__ - 1)][(sym1__ - 1)]);}}
        }
        for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
            vars__.emplace_back(log_lambda_n[(sym2__ - 1)][(sym1__ - 1)]);}}
        for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            vars__.emplace_back(sd_r_mu[(sym2__ - 1)][(sym1__ - 1)]);}}
        for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            vars__.emplace_back(sd_rep[(sym2__ - 1)][(sym1__ - 1)]);}}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      std::vector<Eigen::Matrix<double, -1, 1>> kd;
      kd = std::vector<Eigen::Matrix<double, -1, 1>>(NF, Eigen::Matrix<double, -1, 1>(nMT));
      stan::math::fill(kd, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> L2FC_kd;
      L2FC_kd = std::vector<Eigen::Matrix<double, -1, 1>>(NF, Eigen::Matrix<double, -1, 1>(L2FC_kd_2dim__));
      stan::math::fill(L2FC_kd, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> log_kd;
      log_kd = std::vector<Eigen::Matrix<double, -1, 1>>(NF, Eigen::Matrix<double, -1, 1>(nMT));
      stan::math::fill(log_kd, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 47;
      for (int i = 1; i <= NF; ++i) {
        current_statement__ = 42;
        for (int j = 1; j <= nMT; ++j) {
          current_statement__ = 40;
          if (logical_eq(Chase, 1)) {
            current_statement__ = 37;
            assign(kd,
              cons_list(index_uni(i),
                cons_list(index_uni(j), nil_index_list())),
              (-stan::math::log(inv_logit(alpha[(i - 1)][(j - 1)])) /
                tl[(j - 1)]), "assigning variable kd");
            current_statement__ = 38;
            assign(log_kd,
              cons_list(index_uni(i),
                cons_list(index_uni(j), nil_index_list())),
              stan::math::log(kd[(i - 1)][(j - 1)]),
              "assigning variable log_kd");
          } else {
            current_statement__ = 34;
            assign(kd,
              cons_list(index_uni(i),
                cons_list(index_uni(j), nil_index_list())),
              (-stan::math::log((1 - inv_logit(alpha[(i - 1)][(j - 1)]))) /
                tl[(j - 1)]), "assigning variable kd");
            current_statement__ = 35;
            assign(log_kd,
              cons_list(index_uni(i),
                cons_list(index_uni(j), nil_index_list())),
              stan::math::log(kd[(i - 1)][(j - 1)]),
              "assigning variable log_kd");
          }}
        current_statement__ = 45;
        for (int k = 1; k <= (nMT - 1); ++k) {
          current_statement__ = 43;
          assign(L2FC_kd,
            cons_list(index_uni(i),
              cons_list(index_uni(k), nil_index_list())),
            stan::math::log2(
              (kd[(i - 1)][((k + 1) - 1)] / kd[(i - 1)][(1 - 1)])),
            "assigning variable L2FC_kd");}}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
          vars__.emplace_back(kd[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= L2FC_kd_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
          vars__.emplace_back(L2FC_kd[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
          vars__.emplace_back(log_kd[(sym2__ - 1)][(sym1__ - 1)]);}}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      std::vector<Eigen::Matrix<double, -1, 1>> TL_lambda_eff;
      TL_lambda_eff = std::vector<Eigen::Matrix<double, -1, 1>>(nMT, Eigen::Matrix<double, -1, 1>(nrep));
      stan::math::fill(TL_lambda_eff, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> TL_lambda_eff_flat__;
        current_statement__ = 1;
        assign(TL_lambda_eff_flat__, nil_index_list(),
          context__.vals_r("TL_lambda_eff"),
          "assigning variable TL_lambda_eff_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
          current_statement__ = 1;
          for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
            current_statement__ = 1;
            assign(TL_lambda_eff,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              TL_lambda_eff_flat__[(pos__ - 1)],
              "assigning variable TL_lambda_eff");
            current_statement__ = 1;
            pos__ = (pos__ + 1);}}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> TL_lambda_eff_free__;
      TL_lambda_eff_free__ = std::vector<Eigen::Matrix<double, -1, 1>>(nMT, Eigen::Matrix<double, -1, 1>(nrep));
      stan::math::fill(TL_lambda_eff_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 1;
        for (int sym2__ = 1; sym2__ <= nrep; ++sym2__) {
          current_statement__ = 1;
          assign(TL_lambda_eff_free__,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lb_free(TL_lambda_eff[(sym1__ - 1)][(sym2__ - 1)], 0),
            "assigning variable TL_lambda_eff_free__");}}
      std::vector<Eigen::Matrix<double, -1, 1>> log_lambda_o;
      log_lambda_o = std::vector<Eigen::Matrix<double, -1, 1>>(nMT, Eigen::Matrix<double, -1, 1>(nrep));
      stan::math::fill(log_lambda_o, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> log_lambda_o_flat__;
        current_statement__ = 2;
        assign(log_lambda_o_flat__, nil_index_list(),
          context__.vals_r("log_lambda_o"),
          "assigning variable log_lambda_o_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
          current_statement__ = 2;
          for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
            current_statement__ = 2;
            assign(log_lambda_o,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              log_lambda_o_flat__[(pos__ - 1)],
              "assigning variable log_lambda_o");
            current_statement__ = 2;
            pos__ = (pos__ + 1);}}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> alpha;
      alpha = std::vector<Eigen::Matrix<double, -1, 1>>(NF, Eigen::Matrix<double, -1, 1>(nMT));
      stan::math::fill(alpha, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> alpha_flat__;
        current_statement__ = 3;
        assign(alpha_flat__, nil_index_list(), context__.vals_r("alpha"),
          "assigning variable alpha_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
          current_statement__ = 3;
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            current_statement__ = 3;
            assign(alpha,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              alpha_flat__[(pos__ - 1)], "assigning variable alpha");
            current_statement__ = 3;
            pos__ = (pos__ + 1);}}
      }
      std::vector<double> mu_fn;
      mu_fn = std::vector<double>(nMT, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      assign(mu_fn, nil_index_list(), context__.vals_r("mu_fn"),
        "assigning variable mu_fn");
      std::vector<double> sig_fn;
      sig_fn = std::vector<double>(nMT, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      assign(sig_fn, nil_index_list(), context__.vals_r("sig_fn"),
        "assigning variable sig_fn");
      std::vector<double> sig_fn_free__;
      sig_fn_free__ = std::vector<double>(nMT, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 5;
        assign(sig_fn_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(sig_fn[(sym1__ - 1)], 0),
          "assigning variable sig_fn_free__");}
      std::vector<std::vector<std::vector<double>>> z_fn;
      z_fn = std::vector<std::vector<std::vector<double>>>(NF, std::vector<std::vector<double>>(nMT, std::vector<double>(nrep, std::numeric_limits<double>::quiet_NaN())));
      
      {
        std::vector<local_scalar_t__> z_fn_flat__;
        current_statement__ = 6;
        assign(z_fn_flat__, nil_index_list(), context__.vals_r("z_fn"),
          "assigning variable z_fn_flat__");
        current_statement__ = 6;
        pos__ = 1;
        current_statement__ = 6;
        for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
          current_statement__ = 6;
          for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
            current_statement__ = 6;
            for (int sym3__ = 1; sym3__ <= NF; ++sym3__) {
              current_statement__ = 6;
              assign(z_fn,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                z_fn_flat__[(pos__ - 1)], "assigning variable z_fn");
              current_statement__ = 6;
              pos__ = (pos__ + 1);}}}
      }
      Eigen::Matrix<double, -1, 1> a;
      a = Eigen::Matrix<double, -1, 1>(nMT);
      stan::math::fill(a, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> a_flat__;
        current_statement__ = 7;
        assign(a_flat__, nil_index_list(), context__.vals_r("a"),
          "assigning variable a_flat__");
        current_statement__ = 7;
        pos__ = 1;
        current_statement__ = 7;
        for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
          current_statement__ = 7;
          assign(a, cons_list(index_uni(sym1__), nil_index_list()),
            a_flat__[(pos__ - 1)], "assigning variable a");
          current_statement__ = 7;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> a_free__;
      a_free__ = Eigen::Matrix<double, -1, 1>(nMT);
      stan::math::fill(a_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 7;
        assign(a_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(a[(sym1__ - 1)], 0),
          "assigning variable a_free__");}
      Eigen::Matrix<double, -1, 1> b;
      b = Eigen::Matrix<double, -1, 1>(nMT);
      stan::math::fill(b, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> b_flat__;
        current_statement__ = 8;
        assign(b_flat__, nil_index_list(), context__.vals_r("b"),
          "assigning variable b_flat__");
        current_statement__ = 8;
        pos__ = 1;
        current_statement__ = 8;
        for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
          current_statement__ = 8;
          assign(b, cons_list(index_uni(sym1__), nil_index_list()),
            b_flat__[(pos__ - 1)], "assigning variable b");
          current_statement__ = 8;
          pos__ = (pos__ + 1);}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> z_sd_r;
      z_sd_r = std::vector<Eigen::Matrix<double, -1, 1>>(NF, Eigen::Matrix<double, -1, 1>(nMT));
      stan::math::fill(z_sd_r, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> z_sd_r_flat__;
        current_statement__ = 9;
        assign(z_sd_r_flat__, nil_index_list(), context__.vals_r("z_sd_r"),
          "assigning variable z_sd_r_flat__");
        current_statement__ = 9;
        pos__ = 1;
        current_statement__ = 9;
        for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
          current_statement__ = 9;
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            current_statement__ = 9;
            assign(z_sd_r,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              z_sd_r_flat__[(pos__ - 1)], "assigning variable z_sd_r");
            current_statement__ = 9;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, 1> sig_rep;
      sig_rep = Eigen::Matrix<double, -1, 1>(nMT);
      stan::math::fill(sig_rep, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> sig_rep_flat__;
        current_statement__ = 10;
        assign(sig_rep_flat__, nil_index_list(), context__.vals_r("sig_rep"),
          "assigning variable sig_rep_flat__");
        current_statement__ = 10;
        pos__ = 1;
        current_statement__ = 10;
        for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
          current_statement__ = 10;
          assign(sig_rep, cons_list(index_uni(sym1__), nil_index_list()),
            sig_rep_flat__[(pos__ - 1)], "assigning variable sig_rep");
          current_statement__ = 10;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> sig_rep_free__;
      sig_rep_free__ = Eigen::Matrix<double, -1, 1>(nMT);
      stan::math::fill(sig_rep_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 10;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 10;
        assign(sig_rep_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(sig_rep[(sym1__ - 1)], 0),
          "assigning variable sig_rep_free__");}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nrep; ++sym2__) {
          vars__.emplace_back(
            TL_lambda_eff_free__[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nrep; ++sym2__) {
          vars__.emplace_back(log_lambda_o[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= NF; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          vars__.emplace_back(alpha[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        vars__.emplace_back(mu_fn[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        vars__.emplace_back(sig_fn_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= NF; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= nrep; ++sym3__) {
            vars__.emplace_back(
              z_fn[(sym1__ - 1)][(sym2__ - 1)][(sym3__ - 1)]);}}}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        vars__.emplace_back(a_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        vars__.emplace_back(b[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= NF; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          vars__.emplace_back(z_sd_r[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        vars__.emplace_back(sig_rep_free__[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("TL_lambda_eff");
    names__.emplace_back("log_lambda_o");
    names__.emplace_back("alpha");
    names__.emplace_back("mu_fn");
    names__.emplace_back("sig_fn");
    names__.emplace_back("z_fn");
    names__.emplace_back("a");
    names__.emplace_back("b");
    names__.emplace_back("z_sd_r");
    names__.emplace_back("sig_rep");
    names__.emplace_back("frac_new");
    names__.emplace_back("mu_rep_logit_fn");
    names__.emplace_back("log_lambda_n");
    names__.emplace_back("sd_r_mu");
    names__.emplace_back("sd_rep");
    names__.emplace_back("kd");
    names__.emplace_back("L2FC_kd");
    names__.emplace_back("log_kd");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nMT),
                                             static_cast<size_t>(nrep)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nMT),
                                             static_cast<size_t>(nrep)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NF),
                                             static_cast<size_t>(nMT)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nMT)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nMT)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NF),
                                             static_cast<size_t>(nMT),
                                             static_cast<size_t>(nrep)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nMT)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nMT)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NF),
                                             static_cast<size_t>(nMT)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nMT)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NF),
                                             static_cast<size_t>(nMT),
                                             static_cast<size_t>(nrep)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NF),
                                             static_cast<size_t>(nMT),
                                             static_cast<size_t>(nrep)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nMT),
                                             static_cast<size_t>(nrep)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NF),
                                             static_cast<size_t>(nMT)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NF),
                                             static_cast<size_t>(nMT)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NF),
                                             static_cast<size_t>(nMT)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NF),
                                             static_cast<size_t>(L2FC_kd_2dim__)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NF),
                                             static_cast<size_t>(nMT)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "TL_lambda_eff" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "log_lambda_o" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "alpha" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "mu_fn" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sig_fn" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= NF; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "z_fn" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "a" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "b" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "z_sd_r" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sig_rep" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= NF; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "frac_new" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= NF; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "mu_rep_logit_fn" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "log_lambda_n" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "sd_r_mu" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "sd_rep" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "kd" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= L2FC_kd_2dim__; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "L2FC_kd" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "log_kd" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "TL_lambda_eff" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "log_lambda_o" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "alpha" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "mu_fn" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sig_fn" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= NF; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "z_fn" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "a" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "b" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "z_sd_r" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sig_rep" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= NF; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "frac_new" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= NF; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "mu_rep_logit_fn" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "log_lambda_n" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "sd_r_mu" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "sd_rep" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "kd" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= L2FC_kd_2dim__; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "L2FC_kd" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "log_kd" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"TL_lambda_eff\",\"type\":{\"name\":\"array\",\"length\":" << nMT << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nrep << "}},\"block\":\"parameters\"},{\"name\":\"log_lambda_o\",\"type\":{\"name\":\"array\",\"length\":" << nMT << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nrep << "}},\"block\":\"parameters\"},{\"name\":\"alpha\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nMT << "}},\"block\":\"parameters\"},{\"name\":\"mu_fn\",\"type\":{\"name\":\"array\",\"length\":" << nMT << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sig_fn\",\"type\":{\"name\":\"array\",\"length\":" << nMT << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"z_fn\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"array\",\"length\":" << nMT << ",\"element_type\":{\"name\":\"array\",\"length\":" << nrep << ",\"element_type\":{\"name\":\"real\"}}}},\"block\":\"parameters\"},{\"name\":\"a\",\"type\":{\"name\":\"vector\",\"length\":" << nMT << "},\"block\":\"parameters\"},{\"name\":\"b\",\"type\":{\"name\":\"vector\",\"length\":" << nMT << "},\"block\":\"parameters\"},{\"name\":\"z_sd_r\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nMT << "}},\"block\":\"parameters\"},{\"name\":\"sig_rep\",\"type\":{\"name\":\"vector\",\"length\":" << nMT << "},\"block\":\"parameters\"},{\"name\":\"frac_new\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"array\",\"length\":" << nMT << ",\"element_type\":{\"name\":\"array\",\"length\":" << nrep << ",\"element_type\":{\"name\":\"real\"}}}},\"block\":\"transformed_parameters\"},{\"name\":\"mu_rep_logit_fn\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"array\",\"length\":" << nMT << ",\"element_type\":{\"name\":\"array\",\"length\":" << nrep << ",\"element_type\":{\"name\":\"real\"}}}},\"block\":\"transformed_parameters\"},{\"name\":\"log_lambda_n\",\"type\":{\"name\":\"array\",\"length\":" << nMT << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nrep << "}},\"block\":\"transformed_parameters\"},{\"name\":\"sd_r_mu\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nMT << "}},\"block\":\"transformed_parameters\"},{\"name\":\"sd_rep\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nMT << "}},\"block\":\"transformed_parameters\"},{\"name\":\"kd\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nMT << "}},\"block\":\"generated_quantities\"},{\"name\":\"L2FC_kd\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"vector\",\"length\":" << L2FC_kd_2dim__ << "}},\"block\":\"generated_quantities\"},{\"name\":\"log_kd\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nMT << "}},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"TL_lambda_eff\",\"type\":{\"name\":\"array\",\"length\":" << nMT << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nrep << "}},\"block\":\"parameters\"},{\"name\":\"log_lambda_o\",\"type\":{\"name\":\"array\",\"length\":" << nMT << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nrep << "}},\"block\":\"parameters\"},{\"name\":\"alpha\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nMT << "}},\"block\":\"parameters\"},{\"name\":\"mu_fn\",\"type\":{\"name\":\"array\",\"length\":" << nMT << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sig_fn\",\"type\":{\"name\":\"array\",\"length\":" << nMT << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"z_fn\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"array\",\"length\":" << nMT << ",\"element_type\":{\"name\":\"array\",\"length\":" << nrep << ",\"element_type\":{\"name\":\"real\"}}}},\"block\":\"parameters\"},{\"name\":\"a\",\"type\":{\"name\":\"vector\",\"length\":" << nMT << "},\"block\":\"parameters\"},{\"name\":\"b\",\"type\":{\"name\":\"vector\",\"length\":" << nMT << "},\"block\":\"parameters\"},{\"name\":\"z_sd_r\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nMT << "}},\"block\":\"parameters\"},{\"name\":\"sig_rep\",\"type\":{\"name\":\"vector\",\"length\":" << nMT << "},\"block\":\"parameters\"},{\"name\":\"frac_new\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"array\",\"length\":" << nMT << ",\"element_type\":{\"name\":\"array\",\"length\":" << nrep << ",\"element_type\":{\"name\":\"real\"}}}},\"block\":\"transformed_parameters\"},{\"name\":\"mu_rep_logit_fn\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"array\",\"length\":" << nMT << ",\"element_type\":{\"name\":\"array\",\"length\":" << nrep << ",\"element_type\":{\"name\":\"real\"}}}},\"block\":\"transformed_parameters\"},{\"name\":\"log_lambda_n\",\"type\":{\"name\":\"array\",\"length\":" << nMT << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nrep << "}},\"block\":\"transformed_parameters\"},{\"name\":\"sd_r_mu\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nMT << "}},\"block\":\"transformed_parameters\"},{\"name\":\"sd_rep\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nMT << "}},\"block\":\"transformed_parameters\"},{\"name\":\"kd\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nMT << "}},\"block\":\"generated_quantities\"},{\"name\":\"L2FC_kd\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"vector\",\"length\":" << L2FC_kd_2dim__ << "}},\"block\":\"generated_quantities\"},{\"name\":\"log_kd\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nMT << "}},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_MCMC2_namespace::model_MCMC2;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_MCMC2_namespace::profiles__;
}
#endif
#endif
