% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Visualizations.R
\name{plotVolcano}
\alias{plotVolcano}
\title{Creating L2FC(kdeg) volcano plot from fit objects}
\usage{
plotVolcano(obj, FDR = 0.05, Exps = 2, Exp_shape = FALSE)
}
\arguments{
\item{obj}{Object contained within output of \code{bakRFit}. So, either Fast_Fit (MLE implementation fit),
Stan_Fit (MCMC implementation fit), or Hybrid_Fit (Hybrid implementation fit)}

\item{FDR}{False discovery rate to control at for significance assessment}

\item{Exps}{Vector of Experimental IDs to include in plot; must only contain elements within 2:(# of experimental IDs).
If NULL, data for all Experimental IDs is plotted.}

\item{Exp_shape}{Logical indicating whether to use Experimental ID as factor determining point shape in volcano plot}
}
\value{
A ggplot object. Each point represents a transcript. The x-axis is the
log-2 fold change in the degradation rate constant and the y-axis is the log-10
transformed multiple test adjusted p value.
}
\description{
This function creates a L2FC(kdeg) volcano plot.
Plots are colored according to statistical significance and sign of L2FC(kdeg).
}
\examples{
\donttest{
# Simulate data for 500 genes and 2 replicates
sim <- Simulate_bakRData(500, nreps = 2)

# Fit data with fast implementation
Fit <- bakRFit(sim$bakRData)

# Volcano plot
plotVolcano(Fit$Fast_Fit)

}
}
