% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cBprocessing.R
\name{fn_process}
\alias{fn_process}
\title{Curate data in bakRFnData object for statistical modeling}
\usage{
fn_process(
  obj,
  totcut = 50,
  totcut_all = 10,
  Chase = FALSE,
  FOI = c(),
  concat = TRUE
)
}
\arguments{
\item{obj}{An object of class bakRFnData}

\item{totcut}{Numeric; Any transcripts with less than this number of sequencing reads in any replicate of all experimental conditions are filtered out}

\item{totcut_all}{Numeric; Any transcripts with less than this number of sequencing reads in any sample are filtered out}

\item{Chase}{Boolean; if TRUE, pulse-chase analysis strategy is implemented}

\item{FOI}{Features of interest; character vector containing names of features to analyze. If \code{FOI} is non-null and \code{concat} is TRUE, then
all minimally reliable FOIs will be combined with reliable features passing all set filters (\code{totcut} and \code{totcut_all}).
If \code{concat} is FALSE, only the minimally reliable FOIs will be kept. A minimally reliable FOI is one that passes
filtering with minimally stringent parameters.}

\item{concat}{Boolean; If TRUE, FOI is concatenated with output of reliableFeatures}
}
\value{
returns list of objects that can be passed to \code{TL_stan} and/or \code{fast_analysis}. Those objects are:
\itemize{
\item Stan_data; list that can be passed to \code{TL_stan} with Hybrid_Fit = TRUE. Consists of metadata as well as data that
\code{Stan} will analyze. Data to be analyzed consists of equal length vectors. The contents of Stan_data are:
\itemize{
\item NE; Number of datapoints for 'Stan' to analyze (NE = Number of Elements)
\item NF; Number of features in dataset
\item TP; Numerical indicator of s4U feed (0 = no s4U feed, 1 = s4U fed)
\item FE; Numerical indicator of feature
\item num_mut; Number of U-to-C mutations observed in a particular set of reads
\item MT; Numerical indicator of experimental condition (Exp_ID from metadf)
\item nMT; Number of experimental conditions
\item R; Numerical indicator of replicate
\item nrep; Number of replicates (maximum across experimental conditions)
\item nrep_vect; Vector of number of replicates in each experimental condition
\item tl; Vector of label times for each experimental condition
\item Avg_Reads; Standardized log10(average read counts) for a particular feature in a particular condition, averaged over
replicates
\item sdf; Dataframe that maps numerical feature ID to original feature name. Also has read depth information
\item sample_lookup; Lookup table relating MT and R to the original sample name
}
\item Fn_est; A data frame containing fraction new estimates for +s4U samples:
\itemize{
\item sample; Original sample name
\item XF; Original feature name
\item fn; Fraction new estimate
\item n; Number of reads
\item Feature_ID; Numerical ID for each feature
\item Replicate; Numerical ID for each replicate
\item Exp_ID; Numerical ID for each experimental condition
\item tl; s4U label time
\item logit_fn; logit of fraction new estimate
\item kdeg; degradation rate constant estimate
\item log_kdeg; log of degradation rate constant estimate
\item logit_fn_se; Uncertainty of logit(fraction new) estimate
\item log_kd_se; Uncertainty of log(kdeg) estimate
}
\item Count_Matrix; A matrix with read count information. Each column represents a sample and each row represents a feature.
Each entry is the raw number of read counts mapping to a particular feature in a particular sample. Column names are the corresponding
sample names and row names are the corresponding feature names.
\item Ctl_data; Identical content to Fn_est but for any -s4U data (and thus with fn estimates set to 0). Will be \code{NULL} if no -s4U
data is present
}
}
\description{
\code{fn_process} creates the data structures necessary to analyze nucleotide recoding RNA-seq data with the
MLE and Hybrid implementations in \code{bakRFit}. The input to \code{fn_process} must be an object of class
\code{bakRFnData}.
}
\details{
\code{fn_process} first filters out features with less than totcut reads in any sample. It then
creates the necessary data structures for analysis with \code{bakRFit} and some of the visualization
functions (namely \code{plotMA}).

The 1st step executed by \code{fn_process} is to find the names of features which are deemed "reliable". A reliable feature is one with
sufficient read coverage in every single sample (i.e., > totcut_all reads in all samples) and sufficient read coverage in at all replicates
of at least one experimental condition (i.e., > totcut reads in all replicates for one or more experimental conditions). This is done with a call to \code{reliableFeatures}.

The 2nd step is to extract only reliableFeatures from the fns dataframe in the \code{bakRFnData} object. During this process, a numerical
ID is given to each reliableFeature, with the numerical ID corresponding to their order when arranged using \code{dplyr::arrange}.

The 3rd step is to prepare data structures that can be passed to \code{fast_analysis} and \code{TL_stan} (usually accessed via the
\code{bakRFit} helper function).
}
\examples{
\donttest{

# Load cB
data("cB_small")

# Load metadf
data("metadf")

# Create bakRData
bakRData <- bakRData(cB_small, metadf)

# Preprocess data
data_for_bakR <- cBprocess(obj = bakRData)
}
}
