% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{register_model_from_run}
\alias{register_model_from_run}
\title{Register a model for operationalization.}
\usage{
register_model_from_run(
  run,
  model_name,
  model_path = NULL,
  tags = NULL,
  properties = NULL,
  description = NULL,
  datasets = NULL,
  sample_input_dataset = NULL,
  sample_output_dataset = NULL,
  resource_configuration = NULL
)
}
\arguments{
\item{run}{The \code{Run} object.}

\item{model_name}{The name of the model.}

\item{model_path}{The relative cloud path to the model, for example,
"outputs/modelname". When not specified, \code{model_name} is used as the path.}

\item{tags}{A dictionary of key value tags to assign to the model.}

\item{properties}{A dictionary of key value properties to assign to the model.
These properties cannot be changed after model creation, however new key-value pairs can be added.}

\item{description}{An optional description of the model.}

\item{datasets}{A list of two-element lists where the first element is the
dataset-model relationship and the second is the corresponding dataset, e.g.
\code{list(list("training", train_ds), list("inferencing", infer_ds))}. Valid
values for the data-model relationship are 'training', 'validation', and 'inferencing'.}

\item{sample_input_dataset}{Sample input dataset for the registered model.}

\item{sample_output_dataset}{Sample output dataset for the registered model.}

\item{resource_configuration}{`ResourceConfiguration`` object to run the registered model.}
}
\value{
The registered Model.
}
\description{
Register a model for operationalization.
}
\section{Examples}{
\preformatted{registered_model <- register_model_from_run(run = run,
                                            model_name = "my model",
                                            model_path = 'outputs/model.rds',
                                            tags = list("version" = "0"),
                                            datasets = list(list("training", train_dataset),
                                                            list("validation", validation_dataset)),
                                            resource_configuration = resource_configuration(2, 2, 0))
}
}

\seealso{
\code{\link[=resource_configuration]{resource_configuration()}}
}
