% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canonical_request.R
\name{canonical_request}
\alias{canonical_request}
\title{Construct a Canonical Request}
\usage{
canonical_request(
  verb,
  canonical_uri = "",
  query_args = list(),
  canonical_headers,
  request_body = "",
  signed_body = FALSE
)
}
\arguments{
\item{verb}{A character string containing the HTTP verb being used in the request.}

\item{canonical_uri}{A character string containing the \dQuote{canonical URI}, meaning the contents of the API request URI excluding the host and the query parameters.}

\item{query_args}{A named list of character strings containing the query string values (if any) used in the API request.}

\item{canonical_headers}{A named list of character strings containing the headers used in the request.}

\item{request_body}{The body of the HTTP request, or a filename. If a filename, hashing is performed on the file without reading it into memory.}

\item{signed_body}{Sign the body request and add the correct header (x-amz-content-sha256) to the list of headers}
}
\value{
A list containing
}
\description{
Construct a Canonical Request from request elements
}
\details{
This function creates a \dQuote{Canonical Request}, which is part of the Signature Version 4. Users probably only need to use the \code{\link{signature_v4_auth}} function to generate signatures.
}
\examples{
# From AWS documentation
# http://docs.aws.amazon.com/general/latest/gr/sigv4-create-canonical-request.html
fromDocs <- "POST
/

content-type:application/x-www-form-urlencoded; charset=utf-8
host:iam.amazonaws.com
x-amz-date:20110909T233600Z

content-type;host;x-amz-date
b6359072c78d70ebee1e81adcbab4f01bf2c23245fa365ef83fe8f1f955085e2"

hdrs <- list(`Content-Type` = "application/x-www-form-urlencoded; charset=utf-8",
             Host = "iam.amazonaws.com",
             `x-amz-date` = "20110909T233600Z")
r <- canonical_request(verb = "POST",
                       canonical_uri = "/",
                       query_args = list(),
                       canonical_headers = hdrs,
                       request_body = "Action=ListUsers&Version=2010-05-08")

identical(fromDocs, r$canonical)
}
\references{
\href{http://docs.aws.amazon.com/general/latest/gr/sigv4-create-canonical-request.html}{Create a Canonical Request For Signature Version 4}
}
\seealso{
\code{\link{signature_v4}}, \code{\link{signature_v4_auth}}

\code{link{signature_v4_aut}}, \code{\link{string_to_sign}}
}
\author{
Thomas J. Leeper <thosjleeper@gmail.com>
}
