% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3save.R
\name{s3save}
\alias{s3save}
\alias{s3save_image}
\alias{s3load}
\title{save/load}
\usage{
s3save(..., object, bucket, envir = parent.frame(), opts = NULL)

s3save_image(object, bucket, opts = NULL)

s3load(object, bucket, envir = parent.frame(), ...)
}
\arguments{
\item{...}{For \code{s3save}, one or more R objects to be saved via \code{\link[base]{save}} and uploaded to S3. For \code{s3load}, see \code{opts}.}

\item{object}{For \code{s3save}, a character string of the name of the object you want to save to. For \code{s3load}, a character string of the name of the object you want to load from S3.}

\item{bucket}{Character string with the name of the bucket, or an object of class \dQuote{s3_bucket}.}

\item{envir}{For \code{s3save}, an R environment to save objects from; for \code{s3load}, the environment to load objects into. Default is the \code{parent.frame()} from which the function is called.}

\item{opts}{Additional arguments passed to \code{\link{s3HTTP}}.}
}
\value{
For \code{s3save}, a logical, invisibly. For \code{s3load}, \code{NULL} invisibly.
}
\description{
Save/load R object(s) to/from S3
}
\examples{
\dontrun{
# create bucket
b <- put_bucket("myexamplebucket")

# save a dataset to the bucket
s3save(mtcars, iris, object = "somedata.Rdata", bucket = b)
get_bucket(b)

# load the data from bucket
e <- new.env()
s3load(object = "somedata.Rdata", bucket = b, envir = e)
ls(e)

# cleanup
rm(e)
delete_object(object = "somedata.Rdata", bucket = "myexamplebucket")
delete_bucket("myexamplebucket")
}
}
\references{
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html}{API Documentation}
}
\seealso{
\code{\link{s3saveRDS}},\code{\link{s3readRDS}}
}
