% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifecycle.R
\name{get_lifecycle}
\alias{get_lifecycle}
\alias{put_lifecycle}
\alias{delete_lifecycle}
\title{Lifecycle}
\usage{
get_lifecycle(bucket, ...)

put_lifecycle(bucket, request_body, ...)

delete_lifecycle(bucket, ...)
}
\arguments{
\item{bucket}{Character string with the name of the bucket, or an object of class \dQuote{s3_bucket}.}

\item{\dots}{Additional arguments passed to \code{\link{s3HTTP}}.}

\item{request_body}{A character string containing an XML request body, as defined in the specification in the \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html}{API Documentation}.}
}
\value{
For \code{get_lifecycle}: a list with lifecycle configuration, if it has been configured. For \code{delete_lifecycle}: \code{TRUE} if successful, \code{FALSE} otherwise.
}
\description{
Get/Put/Delete the lifecycle configuration information for a bucket.
}
\references{
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html}{API Documentation: PUT lifecycle}
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycleConfiguration.html}{API Documentation: GET lifecycle}
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketLifecycle.html}{API Documentation: DELETE lifecycle}
}
