#' @name aws.kms-package
#' @title aws.kms
#' @aliases aws.kms-package aws.kms
#' @docType package
#' @description AWS Key Management Service (KMS) Client.
#' @details This is a client for the AWS Key Management Service (KMS), which can be used to create and manage encryption keys used by AWS services or to setup a secure HTTP-based encryption service using \code{\link{encrypt}} and \code{\link{decrypt}}. KMS is also used natively by other AWS services.
#' @references 
#' \url{https://docs.aws.amazon.com/kms/latest/developerguide/overview.html}
#' \url{https://docs.aws.amazon.com/kms/latest/APIReference/Welcome.html}
#' @author Thomas J. Leeper <thosjleeper@gmail.com>
#' @seealso \code{\link{create_kms_key}}, \code{\link{list_kms_keys}}, \code{\link{generate_blob}}, \code{\link{encrypt}}
#' @keywords package 
NULL
