% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user.R
\name{create_user}
\alias{create_user}
\alias{update_user}
\alias{get_user}
\alias{delete_user}
\alias{list_users}
\title{Manage IAM Users}
\usage{
create_user(user, path, ...)

update_user(user, name, path, ...)

get_user(user, ...)

delete_user(user, ...)

list_users(n, marker, path, ...)
}
\arguments{
\item{user}{A character string specifying a user name or an object of class \dQuote{iam_user}.}

\item{path}{A character string specifying a path prefix in which to locate user(s), role(s), etc. See \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html}{Reference Identifiers} on the AWS Documentation for more information.}

\item{\dots}{Additional arguments passed to \code{\link{iamHTTP}}.}

\item{name}{A character string specifying the new name for the user.}

\item{n}{An integer specifying the number of responses to return.}

\item{marker}{A character string specifying a marker (from a previous response) to use in paginating results}
}
\value{
\code{create_user} and \code{get_user} return objects of class \dQuote{iam_user}. \code{update_user} and \code{delete_user} return a logical \code{TRUE} (if successful) or an error. \code{list_users} returns a list of IAM user objects.
}
\description{
Retrieve, create, update, and delete IAM Users
}
\examples{
\dontrun{
list_users()

# create example user
u <- create_user("example-user")

# cleanup
delete_user(u)
}
}
