% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs-actions.R
\name{ecs_describe_container_instances}
\alias{ecs_describe_container_instances}
\title{Describe Container Instances}
\usage{
ecs_describe_container_instances(
  cluster = NULL,
  containerInstances = NULL,
  include = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{cluster}{Character. The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances...}

\item{containerInstances}{List. A list of up to 100 container instance IDs or full Amazon Resource Name (ARN) entries.}

\item{include}{List. Specifies whether you want to see the resource tags for the container instance.}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Describes Amazon Elastic Container Service
container instances. Returns metadata about registered and remaining
resources on each container instance
requested.
}
\section{cluster}{

The short name or full Amazon Resource Name (ARN)
of the cluster that hosts the container instances to describe. If you do
not specify a cluster, the default cluster is assumed. This parameter is
required if the container instance or container instances you are
describing were launched in any cluster other than the default
cluster.
}

\section{containerInstances}{

A list of up to 100 container instance IDs
or full Amazon Resource Name (ARN)
entries.
}

\section{include}{

Specifies whether you want to see the
resource tags for the container instance. If \code{TAGS} is specified, the
tags are included in the response. If this field is omitted, tags are
not included in the response.
}

