% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/training.R
\name{reset_seeds}
\alias{reset_seeds}
\title{Reset all random seeds across R, TensorFlow, and Python}
\usage{
reset_seeds(spec_seed)
}
\arguments{
\item{spec_seed}{Integer. The seed value to apply across R, TensorFlow, and Python.}
}
\value{
No return value but will print a confirmation message.
}
\description{
Ensures reproducibility by synchronizing random seeds across:
\itemize{
\item R's random number generator (\code{set.seed()}),
\item TensorFlow's random state (\code{tf$random$set_seed()}),
\item Python's built-in \code{random} module.
}
}
\details{
This also clears the current Keras/TensorFlow graph and session before
reseeding, preventing residual state from prior model builds.
\itemize{
\item This function is \strong{not} called automatically within AutoTab.
Use it before training runs for reproducibility.
\item Equivalent results still require identical environments
(same TensorFlow, CUDA/cuDNN, and library versions).
}
}
\examples{
\donttest{
if (reticulate::py_module_available("tensorflow")) {
reset_seeds(1234)
}
}


}
\seealso{
\code{\link[=VAE_train]{VAE_train()}}, \code{\link[=set_feat_dist]{set_feat_dist()}}
}
