% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/populate_soln_env.R
\name{populate_soln_env}
\alias{populate_soln_env}
\title{Returns solution environment and test code from template.}
\usage{
populate_soln_env(
  soln_fname,
  pattern,
  knit_root_dir,
  render_only = FALSE,
  output = NULL
)
}
\arguments{
\item{soln_fname}{An rmd file containing the checks to be
run on the student solution.}

\item{pattern}{The pattern that identifies which chunks in the solution are 
are testing chunks. If this argument is missing, 
the default pattern used is "test".}

\item{knit_root_dir}{The root directory to use for knitting the rmd file. This
argument is optional. If it is missing, it uses the root directory in
knitr::opts_knit$get('root.dir').}

\item{render_only}{A logical value. If this is TRUE, then the solution is
run, rendered and returned. Otherwise the rendered html is deleted.}

\item{output}{The path to the knitted solution md file. This is usually 
deleted immediately, but sometimes we may want to keep it. This 
argument is passed on to \code{\link[knitr]{knit}}, so please refer to 
that page for the warnings about setting this argument when figures are 
involved.}
}
\value{
If render_only is FALSE, a list containing 2 components: the
environment populated by the solution rmd and the path to an R script
containing the test code.

If render_only is TRUE, then the output list consists of the 
aforementioned environment, and the path to the rendered solution file
(html). This option is useful for debugging the solution file.
}
\description{
Generates objects for checking solution correctness.
}
\details{
Test code should be written in a chunk that generates scalars 
from student objects.

The solution file has to be an Rmd file (not an R script), because it 
relies on the autoharp.obj and autoharp.scalars knitr hooks being present.

In addition, if it is required that a solution object is to be tested against
the analogous object within the student environment, these objects should be 
listed within the autoharp.objs option of a code chunk. These objects will be 
copied with the "." preffix.

Here is an overview of how the function works:
\enumerate{
  \item Knit the solution file to generate the solution (or "correct") 
  objects. 
  \item Rename these with the "." prefix in the solution environment
  object.
  \item Extract the lines of test code into a temporary R script.
  \item Wrap those chunks that contain autoharp.scalars hook with tryCatch.
  \item Return the solution environment and path to the R test script.
}

Typically, the next step is to call \code{\link{check_correctness}}.
}
\seealso{
\code{\link{check_correctness}}, \code{\link{render_one}}
}
