% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/best_iv.R
\name{best_iv}
\alias{best_iv}
\title{Calculate the Best IV Value for the Binned Data}
\usage{
best_iv(df, variable, bin, method, label_iv)
}
\arguments{
\item{df}{A data.frame with independent variables and target variable.}

\item{variable}{Name of variable.}

\item{bin}{Name of bins.}

\item{method}{Name of method.}

\item{label_iv}{Name of IV.}
}
\value{
A data frame of best IV, including the contents of the bin, the upper bound of the bin, the lower bound of the bin, and all the contents returned by the get_IV function.
}
\description{
Calculate the Best IV Value for the Binned Data
}
\examples{
accepts <- read.csv( system.file( "extdata" , "accepts.csv" , package = "autoScorecard" ))
feature <- stats::na.omit( accepts[,c(1,3,7:23)] )
f_1 <-bins_unsupervised(  df = feature , id="application_id" , label="bad_ind" ,
methods = c("k_means", "equal_width","equal_freq"  )  ,  bin_nums=10  )
best1 <- best_iv( df=f_1 ,bin=c('bins') ,  method = c('method') ,
variable= c( "variable" )  ,label_iv='miv'  )
}
