% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_models.R
\name{plot_ICC}
\alias{plot_ICC}
\title{Plot The Item Characteristic Curves}
\usage{
plot_ICC(
  obj,
  itemno = 5,
  xlab = NULL,
  ylab = NULL,
  xlim = c(-10, 10),
  col = c("green4", "darkorange2", "red2"),
  lty = c(1, 1, 1),
  main = NULL,
  ...
)
}
\arguments{
\item{obj}{The object of class \code{'pcm'}.}

\item{itemno}{A number of the item that is wanted to be plot.}

\item{xlab}{a title for the x axis.}

\item{ylab}{a title for the y axis.}

\item{xlim}{the x limits (x1, x2) of the plot. Note that x1 > x2 is allowed and leads to a ‘reversed axis’.
The default value, \code{NULL}, indicates that the range of the finite values to be plotted should be used;
see \code{\link[graphics:plot.default]{plot.default()}}}

\item{col}{a vector of plotting colors}

\item{lty}{a vector of line types.}

\item{main}{String. Plot title.}

\item{...}{Further arguments to be passed.}
}
\value{
There are no values to return. Instead, it plots the curve of item characteristics from the model.
}
\description{
This function plots the curve(s) of the estimated ability parameters against the probabilities of responses.
}
\examples{
res <- pcm(short_poly_data)
plot_ICC(res, itemno = 4)

}
