% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_scores.R
\name{predict_scores}
\alias{predict_scores}
\title{Predict trait scores based on estimated model}
\usage{
predict_scores(estimated_model, newdata, output_file = NULL)
}
\arguments{
\item{estimated_model}{Estimated model}

\item{newdata}{Response data from new response samples, in TIRT data format. 
Preferably be generated from \code{thurstonianIRT::make_TIRT_data()} or \code{get_TIRT_long_data()}.}

\item{output_file}{Character string. If specified, output the trait scores into a specified csv file.}
}
\value{
A data frame containing estimated trait scores of the new response sample
}
\description{
An easy wrapper for the \code{thurstonianIRT::predict()} function
}
\examples{
test_data <- triplet_example_data[1:20,]
block_info <- triplet_block_info
test_data_long <- get_TIRT_long_data(block_info = triplet_block_info, response_data = test_data,
                                     response_varname = build_TIRT_var_names(N_blocks = 5, 
                                     block_size = 3, item_name = "i"),
                                     block_name = "Block", item_name = "ID", 
                                     trait_name = "Factor", sign_name = "Keying")
\dontrun{
    test_fit <- fit_TIRT_model(test_data_long, method = "mplus")
    predict_scores(test_fit$fit_object, newdata = test_data[21:40,])
}

}
\author{
Mengtong Li
}
