% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimations.R
\name{auction_generate_data}
\alias{auction_generate_data}
\title{Generates sample data for running \code{\link{auction_model}}}
\usage{
auction_generate_data(
  obs = NULL,
  max_n_bids = 10,
  new_x_mean = NULL,
  new_x_sd = NULL,
  mu = NULL,
  alpha = NULL,
  sigma = NULL,
  beta = NULL
)
}
\arguments{
\item{obs}{Number of observations (or auctions) to draw.}

\item{max_n_bids}{Maximum number of bids per auction (must be 3 or greater). The routine generates a vector of length \code{obs} of random numbers between 2 and max_n_bids.}

\item{new_x_mean}{Mean values for observable controls to be generated from a Normal distribution.}

\item{new_x_sd}{Standard deviations for observable controls to be generated from a Normal distribution.}

\item{mu}{Value for mu, or mean, of private value distribution (Weibull) to be generated.}

\item{alpha}{Value for alpha, or shape parameter, of private value distribution (Weibull) to be generated.}

\item{sigma}{Value for standard deviation of unobserved heterogeneity distribution. Note that the distribution is assumed to have mean 1.}

\item{beta}{Coefficients for the generated observable controls. Must be of the same length as \code{new_x_mean} and \code{new_x_sd}.}
}
\value{
A data frame with \code{obs} rows and the following columns:

\item{winning_bid}{numeric values of the winning bids for each observation}
\item{n_bids}{number of bids  for each observation}
\item{X#}{X terms that represent observed heterogeneity}
}
\description{
Generates sample data for running \code{\link{auction_model}}
}
\details{
This function generates example data for feeding into auction_model(). Specifically, the
winning bid, number of bids, and observed heterogeneity are sampled for the specified number of observations.
}
\examples{
dat <- auction_generate_data(obs = 100,
                             mu = 10,
                             new_x_mean= c(-1,1),
                             new_x_sd = c(0.5,0.8),
                             alpha = 2,
                             sigma = 0.2,
                             beta = c(-1,1))
dim(dat)
head(dat)

}
\seealso{
\code{\link{auction_model}}
}
