% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sideinfo_lib.R
\name{asus}
\alias{asus}
\title{Adaptive SURE thresholding with side information (asus)}
\usage{
asus(d, v.d, s, k = 2, m = 50)
}
\arguments{
\item{d}{an n vector of primary observations}

\item{v.d}{an n vector of variances for each component of d}

\item{s}{an n vector of side information}

\item{k}{number of groups. Default is k=2}

\item{m}{partitions the support of \eqn{|s|} into \eqn{m} equidistant points.
Default is \eqn{m=50}}
}
\value{
\enumerate{
\item est - an n vector holding the estimates
\item mse - estimate of risk
\item tau - k-1 vector of grouping parameters if k>=2
\item t - k vector of thresholding parameters
\item size - k vector of group sizes
}
}
\description{
ASUS procedure for shrinkage estimation of a high dimensional sparse parameter.
}
\details{
Estimates a sparse high dimensional vector using the ASUS procedure described in Banerjee et al. (2017).
    If k = 1 then ASUS is the SureShrink estimator. The current implementation of ASUS estimates the grouping thresholds
    based on the magnitude of \eqn{|s|}. See the reference for more details.
}
\examples{
library(asus)
set.seed(42)
d<-rnorm(10,2,1)
v.d<- rep(1,10)
set.seed(42)
s<-rnorm(10,3,0.1)
asus.out<-asus(d,v.d,s)

}
\references{
Banerjee. T, Mukherjee. G and Sun. W. Adaptive Sparse Estimation with Side Information.
Journal of the American Statistical Association 115, no. 532 (2020): 2053-2067.
}
\seealso{
\code{\link{sureshrink}},\code{\link{ejs}},\code{\link{sureshrink.mse}}
}
