% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_comparisons.R
\name{is_less_than}
\alias{is_less_than}
\title{Check if a numeric vector is less than a specified maximum value}
\usage{
is_less_than(x, maximum)
}
\arguments{
\item{x}{a numeric vector to check}

\item{maximum}{The maximum value to compare against}
}
\value{
A logical value indicating whether all elements of the numeric vector x are less than the specified maximum value
}
\description{
This function checks if a numeric vector is less than a specified maximum value. It can also optionally check if all elements of the vector must be less than the maximum value or if only one element is sufficient
}
\examples{
if(interactive()){
is_less_than(c(1,2,3), 4) # TRUE
is_less_than(c(1,2,3), 2) # FALSE
is_less_than(c(1,2,4), 3) # FALSE
}
}
