% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{format_as_bullets}
\alias{format_as_bullets}
\title{Preprocess character vectors for cli::cli_abort()}
\usage{
format_as_bullets(x, bullet = c("*", ">", " ", "x", "v", "i", "!"))
}
\arguments{
\item{x}{A list of character strings}

\item{bullet}{One of '', '>', ' ', 'x', 'v', 'i', '!' (default: '')
The character to use as the bullet point for each element of x.}
}
\value{
A character string with each element of x formatted as a bullet point
}
\description{
The \code{format_as_bullets} function is used for preprocessing character vectors by adding names.
These names are used to denote bullet points when the character vector is passed to \code{cli::cli_abort()}.
This allows for the easy creation of bullet point lists in error messages.
The bullet argument allows the user to specify the desired bullet point symbol.
The default bullet point symbols are: *, >, , x, v, i, and !.
}
