% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_files.R
\name{assert_all_directories_exist}
\alias{assert_all_directories_exist}
\title{Assert all files are directories}
\usage{
assert_all_directories_exist(
  x,
  msg = NULL,
  call = rlang::caller_env(),
  arg_name = NULL
)
}
\arguments{
\item{x}{Paths to directories (character)}

\item{msg}{A character string containing the error message if file \code{x} is does not exist}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if \code{x} is exists and is a directory, otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert that all paths supplied exist and are directories.
To assert a single directory exists, see \code{\link[=assert_directory_exists]{assert_directory_exists()}}
}
\examples{
try({
assert_directory(system.file("package = assertions")) # PASSES
assert_directory("foo") # Throws Error
})

}
\concept{assert_file}
