% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-file.R
\name{find_files}
\alias{find_files}
\title{find_files}
\usage{
find_files(
  file_regx = ".R",
  path = ".",
  recursive = TRUE,
  exclude_files = NULL,
  exclude_dirs = NULL
)
}
\arguments{
\item{file_regx}{= ".*" - a regular expression for files to source}

\item{path}{= "." - a path to search}

\item{recursive}{= TRUE - recurse into subdirectories}

\item{exclude_files}{= NULL - regx for files to exclude}

\item{exclude_dirs}{= NULL - regx for directories to exclude}
}
\value{
list of files
}
\description{
Find files based upon regular expression searching
IMPORTANT - a Directory is NOT a file. (for most instances of file systems)
}
\examples{
find_files(file_regx = ".*",  ## any file name
 path = ".*",   # the current directory and all subdirectories
 recursive = FALSE,  # don't recurse
 exclude_files = ".*utility.*", # exclude "utility" anywhere in basename
 exclude_dirs = "\\\\<tmp\\\\>|/tmp/|/tmp\\\\>|\\\\<tmp/"  # exclude any directory named "tmp", or subdirs
 )

}
